/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.vcloud.options;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.collect.Sets;
import java.util.Set;
import org.jclouds.vcloud.domain.network.NetworkConfig;

public class InstantiateVAppTemplateOptions {
    private Set<NetworkConfig> networkConfig = Sets.newLinkedHashSet();
    private Boolean customizeOnInstantiate;
    private String description = null;
    private boolean deploy = true;
    private boolean powerOn = true;

    public String getDescription() {
        return this.description;
    }

    public boolean shouldDeploy() {
        return this.deploy;
    }

    public boolean shouldPowerOn() {
        return this.powerOn;
    }

    public InstantiateVAppTemplateOptions description(String description) {
        this.description = description;
        return this;
    }

    public InstantiateVAppTemplateOptions deploy(boolean deploy) {
        this.deploy = deploy;
        return this;
    }

    public InstantiateVAppTemplateOptions powerOn(boolean powerOn) {
        this.powerOn = powerOn;
        return this;
    }

    public InstantiateVAppTemplateOptions addNetworkConfig(NetworkConfig networkConfig) {
        this.networkConfig.add(Preconditions.checkNotNull(networkConfig, "networkConfig"));
        return this;
    }

    public Set<NetworkConfig> getNetworkConfig() {
        return this.networkConfig;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof InstantiateVAppTemplateOptions) {
            InstantiateVAppTemplateOptions other = (InstantiateVAppTemplateOptions)InstantiateVAppTemplateOptions.class.cast(object);
            return Objects.equal(this.networkConfig, other.networkConfig) && Objects.equal(this.customizeOnInstantiate, other.customizeOnInstantiate) && Objects.equal(this.description, other.description) && Objects.equal(this.deploy, other.deploy) && Objects.equal(this.powerOn, other.powerOn);
        }
        return false;
    }

    public int hashCode() {
        return Objects.hashCode(this.networkConfig, this.customizeOnInstantiate, this.description, this.deploy, this.powerOn);
    }

    public String toString() {
        return this.string().toString();
    }

    protected Objects.ToStringHelper string() {
        Objects.ToStringHelper toString = Objects.toStringHelper("").omitNullValues();
        toString.add("customizeOnInstantiate", this.customizeOnInstantiate).add("description", this.description);
        if (this.networkConfig.size() > 0) {
            toString.add("networkConfig", this.networkConfig);
        }
        if (!this.deploy) {
            toString.add("deploy", this.deploy);
        }
        if (!this.powerOn) {
            toString.add("powerOn", this.powerOn);
        }
        return toString;
    }

    public static class Builder {
        public static InstantiateVAppTemplateOptions description(String description) {
            InstantiateVAppTemplateOptions options = new InstantiateVAppTemplateOptions();
            return options.description(description);
        }

        public static InstantiateVAppTemplateOptions deploy(boolean deploy) {
            InstantiateVAppTemplateOptions options = new InstantiateVAppTemplateOptions();
            return options.deploy(deploy);
        }

        public static InstantiateVAppTemplateOptions powerOn(boolean powerOn) {
            InstantiateVAppTemplateOptions options = new InstantiateVAppTemplateOptions();
            return options.powerOn(powerOn);
        }

        public static InstantiateVAppTemplateOptions addNetworkConfig(NetworkConfig networkConfig) {
            InstantiateVAppTemplateOptions options = new InstantiateVAppTemplateOptions();
            return options.addNetworkConfig(networkConfig);
        }
    }
}

