/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.vcloud.location;

import com.google.common.base.Preconditions;
import com.google.common.base.Supplier;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import java.net.URI;
import java.util.Map;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.jclouds.domain.Location;
import org.jclouds.domain.LocationBuilder;
import org.jclouds.domain.LocationScope;
import org.jclouds.location.Iso3166;
import org.jclouds.location.Provider;
import org.jclouds.location.suppliers.LocationsSupplier;
import org.jclouds.location.suppliers.all.JustProvider;
import org.jclouds.vcloud.domain.Org;
import org.jclouds.vcloud.domain.ReferenceType;

@Singleton
public class OrgAndVDCToLocationSupplier
extends JustProvider
implements LocationsSupplier {
    private final Supplier<Map<String, ReferenceType>> orgNameToResource;
    private final Supplier<Map<String, Org>> orgNameToVDCResource;
    private final Supplier<Map<String, Supplier<Set<String>>>> isoCodesByIdSupplier;

    @Inject
    OrgAndVDCToLocationSupplier(@Iso3166 Set<String> isoCodes, @Provider String providerName, @Provider Supplier<URI> endpoint, @org.jclouds.vcloud.endpoints.Org Supplier<Map<String, ReferenceType>> orgNameToResource, Supplier<Map<String, Org>> orgNameToVDCResource, @Iso3166 Supplier<Map<String, Supplier<Set<String>>>> isoCodesByIdSupplier) {
        super(providerName, endpoint, isoCodes);
        this.orgNameToResource = Preconditions.checkNotNull(orgNameToResource, "orgNameToResource");
        this.orgNameToVDCResource = Preconditions.checkNotNull(orgNameToVDCResource, "orgNameToVDCResource");
        this.isoCodesByIdSupplier = Preconditions.checkNotNull(isoCodesByIdSupplier, "isoCodesByIdSupplier");
    }

    @Override
    public Set<Location> get() {
        return this.buildJustProviderOrVDCs().build();
    }

    protected ImmutableSet.Builder<Location> buildJustProviderOrVDCs() {
        ImmutableSet.Builder<Location> locations = ImmutableSet.builder();
        Location provider = (Location)Iterables.getOnlyElement(super.get());
        if (this.orgNameToResource.get().size() == 0) {
            return locations.add((Object)provider);
        }
        Map<String, Supplier<Set<String>>> isoCodesById = this.isoCodesByIdSupplier.get();
        for (ReferenceType org : this.orgNameToResource.get().values()) {
            LocationBuilder builder = new LocationBuilder().scope(LocationScope.REGION).id(org.getHref().toASCIIString()).description(org.getName()).parent(provider);
            if (isoCodesById.containsKey(org.getHref().toASCIIString())) {
                builder.iso3166Codes((Iterable<String>)isoCodesById.get(org.getHref().toASCIIString()).get());
            }
            Location orgL = builder.build();
            for (ReferenceType vdc : this.orgNameToVDCResource.get().get(org.getName()).getVDCs().values()) {
                builder = new LocationBuilder().scope(LocationScope.ZONE).id(vdc.getHref().toASCIIString()).description(vdc.getName()).parent(orgL);
                if (isoCodesById.containsKey(vdc.getHref().toASCIIString())) {
                    builder.iso3166Codes((Iterable<String>)isoCodesById.get(vdc.getHref().toASCIIString()).get());
                }
                locations.add((Object)builder.build());
            }
        }
        return locations;
    }
}

