/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.vcloud.functions;

import com.google.common.base.Function;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import javax.annotation.Resource;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.jclouds.concurrent.FutureIterables;
import org.jclouds.logging.Logger;
import org.jclouds.util.Iterables2;
import org.jclouds.vcloud.VCloudAsyncClient;
import org.jclouds.vcloud.domain.Org;
import org.jclouds.vcloud.domain.ReferenceType;
import org.jclouds.vcloud.domain.VDC;

@Singleton
public class VDCsInOrg
implements Function<Org, Iterable<VDC>> {
    @Resource
    public Logger logger = Logger.NULL;
    private final VCloudAsyncClient aclient;
    private final ExecutorService executor;

    @Inject
    VDCsInOrg(VCloudAsyncClient aclient, @Named(value="jclouds.user-threads") ExecutorService executor) {
        this.aclient = aclient;
        this.executor = executor;
    }

    @Override
    public Iterable<VDC> apply(Org org) {
        Iterable<? extends VDC> catalogItems = FutureIterables.transformParallel(org.getVDCs().values(), new Function<ReferenceType, Future<? extends VDC>>(){

            @Override
            public Future<? extends VDC> apply(ReferenceType from) {
                return VDCsInOrg.this.aclient.getVDCClient().getVDC(from.getHref());
            }
        }, this.executor, null, this.logger, "vdcs in org " + org.getName());
        return Iterables2.concreteCopy(catalogItems);
    }
}

