/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.vcloud.functions;

import com.google.common.base.Function;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import javax.annotation.Resource;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.jclouds.concurrent.FutureIterables;
import org.jclouds.logging.Logger;
import org.jclouds.util.Iterables2;
import org.jclouds.vcloud.VCloudAsyncClient;
import org.jclouds.vcloud.domain.Catalog;
import org.jclouds.vcloud.domain.Org;
import org.jclouds.vcloud.domain.ReferenceType;

@Singleton
public class CatalogsInOrg
implements Function<Org, Iterable<Catalog>> {
    @Resource
    public Logger logger = Logger.NULL;
    private final VCloudAsyncClient aclient;
    private final ExecutorService executor;

    @Inject
    CatalogsInOrg(VCloudAsyncClient aclient, @Named(value="jclouds.user-threads") ExecutorService executor) {
        this.aclient = aclient;
        this.executor = executor;
    }

    @Override
    public Iterable<Catalog> apply(Org org) {
        Iterable<? extends Catalog> catalogs = FutureIterables.transformParallel(org.getCatalogs().values(), new Function<ReferenceType, Future<? extends Catalog>>(){

            @Override
            public Future<Catalog> apply(ReferenceType from) {
                return CatalogsInOrg.this.aclient.getCatalogClient().getCatalog(from.getHref());
            }
        }, this.executor, null, this.logger, "catalogs in " + org.getName());
        return Iterables2.concreteCopy(catalogs);
    }
}

