/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.vcloud.filters;

import com.google.common.base.Supplier;
import com.google.common.collect.ImmutableMultimap;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.jclouds.http.HttpException;
import org.jclouds.http.HttpRequest;
import org.jclouds.http.HttpRequestFilter;
import org.jclouds.vcloud.VCloudToken;

@Singleton
public class AddVCloudAuthorizationAndCookieToRequest
implements HttpRequestFilter {
    private Supplier<String> vcloudTokenProvider;

    @Inject
    public AddVCloudAuthorizationAndCookieToRequest(@VCloudToken Supplier<String> authTokenProvider) {
        this.vcloudTokenProvider = authTokenProvider;
    }

    @Override
    public HttpRequest filter(HttpRequest request) throws HttpException {
        String token = this.vcloudTokenProvider.get();
        return ((HttpRequest.Builder)request.toBuilder().replaceHeaders(ImmutableMultimap.of("x-vcloud-authorization", token, "Cookie", "vcloud-token=" + token))).build();
    }
}

