/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.vcloud.domain;

import org.jclouds.javax.annotation.Nullable;
import org.jclouds.vcloud.domain.network.IpAddressAllocationMode;

public class NetworkConnection {
    private final String network;
    private final int networkConnectionIndex;
    @Nullable
    private final String ipAddress;
    @Nullable
    private final String externalIpAddress;
    private final boolean connected;
    @Nullable
    private final String MACAddress;
    private final IpAddressAllocationMode ipAddressAllocationMode;

    public static Builder builder() {
        return new Builder();
    }

    public NetworkConnection(String network, int networkConnectionIndex, @Nullable String ipAddress, @Nullable String externalIpAddress, boolean connected, @Nullable String MACAddress, IpAddressAllocationMode ipAddressAllocationMode) {
        this.network = network;
        this.networkConnectionIndex = networkConnectionIndex;
        this.ipAddress = ipAddress;
        this.externalIpAddress = externalIpAddress;
        this.connected = connected;
        this.MACAddress = MACAddress;
        this.ipAddressAllocationMode = ipAddressAllocationMode;
    }

    public String getNetwork() {
        return this.network;
    }

    public int getNetworkConnectionIndex() {
        return this.networkConnectionIndex;
    }

    @Nullable
    public String getIpAddress() {
        return this.ipAddress;
    }

    @Nullable
    public String getExternalIpAddress() {
        return this.externalIpAddress;
    }

    public boolean isConnected() {
        return this.connected;
    }

    @Nullable
    public String getMACAddress() {
        return this.MACAddress;
    }

    public IpAddressAllocationMode getIpAddressAllocationMode() {
        return this.ipAddressAllocationMode;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.MACAddress == null ? 0 : this.MACAddress.hashCode());
        result = 31 * result + (this.connected ? 1231 : 1237);
        result = 31 * result + (this.externalIpAddress == null ? 0 : this.externalIpAddress.hashCode());
        result = 31 * result + (this.ipAddress == null ? 0 : this.ipAddress.hashCode());
        result = 31 * result + (this.ipAddressAllocationMode == null ? 0 : this.ipAddressAllocationMode.hashCode());
        result = 31 * result + (this.network == null ? 0 : this.network.hashCode());
        result = 31 * result + this.networkConnectionIndex;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        NetworkConnection other = (NetworkConnection)obj;
        if (this.MACAddress == null ? other.MACAddress != null : !this.MACAddress.equals(other.MACAddress)) {
            return false;
        }
        if (this.connected != other.connected) {
            return false;
        }
        if (this.externalIpAddress == null ? other.externalIpAddress != null : !this.externalIpAddress.equals(other.externalIpAddress)) {
            return false;
        }
        if (this.ipAddress == null ? other.ipAddress != null : !this.ipAddress.equals(other.ipAddress)) {
            return false;
        }
        if (this.ipAddressAllocationMode == null ? other.ipAddressAllocationMode != null : !this.ipAddressAllocationMode.equals((Object)other.ipAddressAllocationMode)) {
            return false;
        }
        if (this.network == null ? other.network != null : !this.network.equals(other.network)) {
            return false;
        }
        return this.networkConnectionIndex == other.networkConnectionIndex;
    }

    public Builder toBuilder() {
        return Builder.fromNetworkConnection(this);
    }

    public String toString() {
        return "[network=" + this.network + ", connected=" + this.connected + ", ipAddress=" + this.ipAddress + ", externalIpAddress=" + this.externalIpAddress + ", networkConnectionIndex=" + this.networkConnectionIndex + ", ipAddressAllocationMode=" + (Object)((Object)this.ipAddressAllocationMode) + ", MACAddress=" + this.MACAddress + "]";
    }

    public static class Builder {
        private String network;
        private int networkConnectionIndex;
        private String ipAddress;
        private String externalIpAddress;
        private boolean connected;
        private String MACAddress;
        private IpAddressAllocationMode ipAddressAllocationMode;

        public Builder network(String network) {
            this.network = network;
            return this;
        }

        public Builder networkConnectionIndex(int networkConnectionIndex) {
            this.networkConnectionIndex = networkConnectionIndex;
            return this;
        }

        public Builder ipAddress(String ipAddress) {
            this.ipAddress = ipAddress;
            return this;
        }

        public Builder externalIpAddress(String externalIpAddress) {
            this.externalIpAddress = externalIpAddress;
            return this;
        }

        public Builder connected(boolean connected) {
            this.connected = connected;
            return this;
        }

        public Builder MACAddress(String MACAddress) {
            this.MACAddress = MACAddress;
            return this;
        }

        public Builder ipAddressAllocationMode(IpAddressAllocationMode ipAddressAllocationMode) {
            this.ipAddressAllocationMode = ipAddressAllocationMode;
            return this;
        }

        public NetworkConnection build() {
            return new NetworkConnection(this.network, this.networkConnectionIndex, this.ipAddress, this.externalIpAddress, this.connected, this.MACAddress, this.ipAddressAllocationMode);
        }

        public static Builder fromNetworkConnection(NetworkConnection in) {
            return new Builder().network(in.getNetwork()).networkConnectionIndex(in.getNetworkConnectionIndex()).ipAddress(in.getIpAddress()).externalIpAddress(in.getExternalIpAddress()).connected(in.isConnected()).MACAddress(in.getMACAddress()).ipAddressAllocationMode(in.getIpAddressAllocationMode());
        }
    }
}

