/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.vcloud.config;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Supplier;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.jclouds.vcloud.domain.Org;
import org.jclouds.vcloud.domain.ReferenceType;

@Singleton
public class DefaultTasksListForOrg
implements Function<ReferenceType, ReferenceType> {
    private final Supplier<Map<String, Org>> nameToOrg;

    @Inject
    public DefaultTasksListForOrg(Supplier<Map<String, Org>> nameToOrg) {
        this.nameToOrg = Preconditions.checkNotNull(nameToOrg, "nameToOrg");
    }

    @Override
    public ReferenceType apply(ReferenceType defaultOrg) {
        Org org = this.nameToOrg.get().get(defaultOrg.getName());
        Preconditions.checkState(org != null, "could not retrieve Org at %s", defaultOrg);
        return org.getTasksList();
    }
}

