/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.vcloud.config;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Supplier;
import java.net.URI;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.jclouds.config.ValueOfConfigurationKeyOrNull;
import org.jclouds.vcloud.domain.ReferenceType;
import org.jclouds.vcloud.domain.VDC;
import org.jclouds.vcloud.endpoints.Network;
import org.jclouds.vcloud.suppliers.OnlyReferenceTypeFirstWithNameMatchingConfigurationKeyOrDefault;

@Singleton
public class DefaultNetworkForVDC
implements Function<ReferenceType, ReferenceType> {
    private final OnlyReferenceTypeFirstWithNameMatchingConfigurationKeyOrDefault selector;
    private final Supplier<Map<URI, VDC>> uriToVDC;

    @Inject
    public DefaultNetworkForVDC(ValueOfConfigurationKeyOrNull valueOfConfigurationKeyOrNull, @Network Predicate<ReferenceType> defaultSelector, Supplier<Map<URI, VDC>> uriToVDC) {
        this.selector = new OnlyReferenceTypeFirstWithNameMatchingConfigurationKeyOrDefault(Preconditions.checkNotNull(valueOfConfigurationKeyOrNull, "valueOfConfigurationKeyOrNull"), "jclouds.vcloud.defaults.network", Preconditions.checkNotNull(defaultSelector, "defaultSelector"));
        this.uriToVDC = Preconditions.checkNotNull(uriToVDC, "uriToVDC");
    }

    @Override
    public ReferenceType apply(ReferenceType defaultVDC) {
        VDC vDC = this.uriToVDC.get().get(defaultVDC.getHref());
        Preconditions.checkState(vDC != null, "could not retrieve VDC at %s", defaultVDC);
        return this.selector.apply((Iterable<ReferenceType>)vDC.getAvailableNetworks().values());
    }
}

