/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.vcloud.binders;

import com.google.common.base.Preconditions;
import com.google.inject.Inject;
import com.jamesmurty.utils.XMLBuilder;
import java.net.URI;
import java.util.Map;
import java.util.Properties;
import javax.inject.Named;
import javax.inject.Singleton;
import javax.xml.parsers.FactoryConfigurationError;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import org.jclouds.http.HttpRequest;
import org.jclouds.rest.MapBinder;
import org.jclouds.rest.binders.BindToStringPayload;
import org.jclouds.rest.internal.GeneratedHttpRequest;
import org.jclouds.vcloud.options.CatalogItemOptions;

@Singleton
public class BindCatalogItemToXmlPayload
implements MapBinder {
    protected final String ns;
    protected final String schema;
    private final BindToStringPayload stringBinder;

    @Inject
    public BindCatalogItemToXmlPayload(BindToStringPayload stringBinder, @Named(value="jclouds.vcloud.xml.ns") String ns, @Named(value="jclouds.vcloud.xml.schema") String schema) {
        this.ns = ns;
        this.schema = schema;
        this.stringBinder = stringBinder;
    }

    @Override
    public <R extends HttpRequest> R bindToRequest(R request, Map<String, Object> postParams) {
        Preconditions.checkArgument(Preconditions.checkNotNull(request, "request") instanceof GeneratedHttpRequest, "this binder is only valid for GeneratedHttpRequests!");
        GeneratedHttpRequest gRequest = (GeneratedHttpRequest)request;
        Preconditions.checkState(gRequest.getArgs() != null, "args should be initialized at this point");
        String name = Preconditions.checkNotNull(postParams.get("name"), "name").toString();
        URI entity = URI.create(Preconditions.checkNotNull(postParams.get("Entity"), "Entity").toString());
        CatalogItemOptions options = this.findOptionsInArgsOrNew(gRequest);
        try {
            return this.stringBinder.bindToRequest(request, this.generateXml(name, entity, options));
        }
        catch (ParserConfigurationException e) {
            throw new RuntimeException(e);
        }
        catch (FactoryConfigurationError e) {
            throw new RuntimeException(e);
        }
        catch (TransformerException e) {
            throw new RuntimeException(e);
        }
    }

    protected String generateXml(String templateName, URI entity, CatalogItemOptions options) throws ParserConfigurationException, FactoryConfigurationError, TransformerException {
        XMLBuilder rootBuilder = this.buildRoot(templateName);
        if (options.getDescription() != null) {
            rootBuilder.e("Description").t(options.getDescription());
        }
        rootBuilder.e("Entity").a("href", entity.toASCIIString());
        for (Map.Entry<String, String> entry : options.getProperties().entrySet()) {
            rootBuilder.e("Property").a("key", entry.getKey()).t(entry.getValue());
        }
        Properties outputProperties = new Properties();
        outputProperties.put("omit-xml-declaration", "yes");
        return rootBuilder.asString(outputProperties);
    }

    protected XMLBuilder buildRoot(String name) throws ParserConfigurationException, FactoryConfigurationError {
        XMLBuilder rootBuilder = XMLBuilder.create("CatalogItem").a("name", name).a("xmlns", this.ns).a("xmlns:xsi", "http://www.w3.org/2001/XMLSchema-instance").a("xsi:schemaLocation", this.ns + " " + this.schema);
        return rootBuilder;
    }

    protected CatalogItemOptions findOptionsInArgsOrNew(GeneratedHttpRequest gRequest) {
        for (Object arg : gRequest.getArgs()) {
            Object[] array;
            if (arg instanceof CatalogItemOptions) {
                return (CatalogItemOptions)CatalogItemOptions.class.cast(arg);
            }
            if (!arg.getClass().isArray() || (array = (Object[])arg).length <= 0 || !(array[0] instanceof CatalogItemOptions)) continue;
            return (CatalogItemOptions)CatalogItemOptions.class.cast(array[0]);
        }
        return new CatalogItemOptions();
    }

    @Override
    public <R extends HttpRequest> R bindToRequest(R request, Object input) {
        throw new IllegalStateException("CatalogItem is needs parameters");
    }

    protected String ifNullDefaultTo(String value, String defaultValue) {
        return value != null ? value : Preconditions.checkNotNull(defaultValue, "defaultValue");
    }
}

