/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.trmk.vcloud_0_8.xml;

import com.google.common.collect.Sets;
import java.util.Map;
import java.util.SortedSet;
import javax.inject.Inject;
import org.jclouds.http.functions.ParseSax;
import org.jclouds.trmk.vcloud_0_8.domain.ReferenceType;
import org.jclouds.trmk.vcloud_0_8.domain.Task;
import org.jclouds.trmk.vcloud_0_8.domain.TasksList;
import org.jclouds.trmk.vcloud_0_8.domain.internal.TasksListImpl;
import org.jclouds.trmk.vcloud_0_8.util.Utils;
import org.jclouds.trmk.vcloud_0_8.xml.TaskHandler;
import org.jclouds.util.SaxUtils;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class TasksListHandler
extends ParseSax.HandlerWithResult<TasksList> {
    private SortedSet<Task> tasks = Sets.newTreeSet();
    private final TaskHandler taskHandler;
    private ReferenceType resource;

    @Inject
    public TasksListHandler(TaskHandler taskHandler) {
        this.taskHandler = taskHandler;
    }

    @Override
    public TasksList getResult() {
        return new TasksListImpl(this.resource.getHref(), this.tasks);
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attrs) throws SAXException {
        Map<String, String> attributes = SaxUtils.cleanseAttributes(attrs);
        if (qName.equals("TasksList")) {
            this.resource = Utils.newReferenceType(attributes);
        } else if (qName.equals("Link") && "self".equals(attributes.get("rel"))) {
            this.resource = Utils.newReferenceType(attributes);
        } else {
            this.taskHandler.startElement(uri, localName, qName, attrs);
        }
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        this.taskHandler.endElement(uri, localName, qName);
        if (qName.equals("Task")) {
            this.tasks.add(this.taskHandler.getResult());
        }
    }
}

