/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.trmk.vcloud_0_8.xml;

import java.net.URI;
import org.jclouds.http.functions.ParseSax;
import org.jclouds.trmk.vcloud_0_8.domain.NetworkExtendedInfo;
import org.jclouds.util.SaxUtils;

public class NetworkExtendedInfoHandler
extends ParseSax.HandlerWithResult<NetworkExtendedInfo> {
    private StringBuilder currentText = new StringBuilder();
    private String id;
    private URI href;
    private String name;
    private String rnatAddress;
    private String address;
    private String broadcastAddress;
    private String gatewayAddress;
    private NetworkExtendedInfo.Type networkType;
    private String vlan;
    private String friendlyName;

    @Override
    public NetworkExtendedInfo getResult() {
        return new NetworkExtendedInfo(this.id, this.href, this.name, this.rnatAddress, this.address, this.broadcastAddress, this.gatewayAddress, this.networkType, this.vlan, this.friendlyName);
    }

    @Override
    public void endElement(String uri, String name, String qName) {
        String current = SaxUtils.currentOrNull(this.currentText);
        if (current != null) {
            if (SaxUtils.equalsOrSuffix(qName, "Href")) {
                this.href = URI.create(current);
            } else if (SaxUtils.equalsOrSuffix(qName, "Id")) {
                this.id = current;
            } else if (SaxUtils.equalsOrSuffix(qName, "Name")) {
                this.name = current;
            } else if (SaxUtils.equalsOrSuffix(qName, "RnatAddress")) {
                this.rnatAddress = current;
            } else if (SaxUtils.equalsOrSuffix(qName, "Address")) {
                this.address = current;
            } else if (SaxUtils.equalsOrSuffix(qName, "BroadcastAddress")) {
                this.broadcastAddress = current;
            } else if (SaxUtils.equalsOrSuffix(qName, "GatewayAddress")) {
                this.gatewayAddress = current;
            } else if (SaxUtils.equalsOrSuffix(qName, "NetworkType")) {
                this.networkType = NetworkExtendedInfo.Type.fromValue(current);
            } else if (SaxUtils.equalsOrSuffix(qName, "Vlan")) {
                this.vlan = current;
            } else if (SaxUtils.equalsOrSuffix(qName, "FriendlyName")) {
                this.friendlyName = current;
            }
        }
        this.currentText = new StringBuilder();
    }

    @Override
    public void characters(char[] ch, int start, int length) {
        this.currentText.append(ch, start, length);
    }
}

