/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.trmk.vcloud_0_8.functions;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Supplier;
import com.google.common.collect.Iterables;
import java.net.URI;
import java.util.Map;
import java.util.NoSuchElementException;
import javax.inject.Inject;
import org.jclouds.trmk.vcloud_0_8.domain.ReferenceType;
import org.jclouds.trmk.vcloud_0_8.domain.VDC;
import org.jclouds.trmk.vcloud_0_8.endpoints.Org;

public abstract class OrgNameVDCNameResourceNameToEndpoint
implements Function<Object, URI> {
    protected final Supplier<Map<String, Map<String, ? extends VDC>>> orgVDCMap;
    protected final Supplier<ReferenceType> defaultOrg;
    protected final Supplier<ReferenceType> defaultVDC;

    @Inject
    public OrgNameVDCNameResourceNameToEndpoint(Supplier<Map<String, Map<String, ? extends VDC>>> orgVDCMap, @Org Supplier<ReferenceType> defaultOrg, @org.jclouds.trmk.vcloud_0_8.endpoints.VDC Supplier<ReferenceType> defaultVDC) {
        this.orgVDCMap = orgVDCMap;
        this.defaultOrg = defaultOrg;
        this.defaultVDC = defaultVDC;
    }

    @Override
    public URI apply(Object from) {
        Map<String, Map<String, ? extends VDC>> orgToVDCs;
        Iterable orgVDC = (Iterable)Preconditions.checkNotNull(from, "args");
        Object org = Iterables.get(orgVDC, 0);
        Object vDC = Iterables.get(orgVDC, 1);
        Object resource = Iterables.get(orgVDC, 2);
        if (org == null) {
            org = this.defaultOrg.get().getName();
        }
        if (vDC == null) {
            vDC = this.defaultVDC.get().getName();
        }
        Preconditions.checkState((orgToVDCs = this.orgVDCMap.get()) != null, "could not get map of org name to vdcs!");
        Map<String, ? extends VDC> vDCs = orgToVDCs.get(org);
        if (vDCs == null) {
            throw new NoSuchElementException("org " + org + " not found in " + orgToVDCs.keySet());
        }
        VDC vDCObject = vDCs.get(vDC);
        if (vDCObject == null) {
            throw new NoSuchElementException("vdc " + vDC + " in org " + org + " not found in " + vDCs.keySet());
        }
        return this.getEndpointOfResourceInVDC(org, vDC, resource, vDCObject);
    }

    protected abstract URI getEndpointOfResourceInVDC(Object var1, Object var2, Object var3, VDC var4);
}

