/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.trmk.vcloud_0_8.compute.strategy;

import java.util.Map;
import javax.annotation.Resource;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.jclouds.domain.Credentials;
import org.jclouds.logging.Logger;
import org.jclouds.trmk.vcloud_0_8.TerremarkVCloudClient;
import org.jclouds.trmk.vcloud_0_8.compute.domain.OrgAndName;
import org.jclouds.trmk.vcloud_0_8.domain.KeyPair;

@Singleton
public class DeleteKeyPair {
    @Resource
    @Named(value="jclouds.compute")
    protected Logger logger = Logger.NULL;
    final TerremarkVCloudClient terremarkClient;
    final Map<String, Credentials> credentialStore;

    @Inject
    DeleteKeyPair(TerremarkVCloudClient terremarkClient, Map<String, Credentials> credentialStore) {
        this.terremarkClient = terremarkClient;
        this.credentialStore = credentialStore;
    }

    public void execute(OrgAndName orgTag) {
        for (KeyPair keyPair : this.terremarkClient.listKeyPairsInOrg(orgTag.getOrg())) {
            if (!keyPair.getName().matches("jclouds_" + orgTag.getName().replaceAll("-", "_") + "_[0-9a-f]+")) continue;
            this.logger.debug(">> deleting keyPair(%s)", keyPair.getName());
            this.terremarkClient.deleteKeyPair(keyPair.getId());
            this.logger.debug("<< deleted keyPair(%s)", keyPair.getName());
            this.credentialStore.remove("group#" + orgTag.getName());
        }
    }
}

