/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.trmk.vcloud_0_8.compute.functions;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import java.util.Map;
import javax.inject.Inject;
import org.jclouds.compute.domain.Image;
import org.jclouds.compute.domain.ImageBuilder;
import org.jclouds.compute.domain.OperatingSystem;
import org.jclouds.compute.strategy.PopulateDefaultLoginCredentialsForImageStrategy;
import org.jclouds.trmk.vcloud_0_8.compute.functions.FindLocationForResource;
import org.jclouds.trmk.vcloud_0_8.domain.ReferenceType;
import org.jclouds.trmk.vcloud_0_8.domain.Status;
import org.jclouds.trmk.vcloud_0_8.domain.VAppTemplate;

public class ImageForVCloudExpressVAppTemplate
implements Function<VAppTemplate, Image> {
    private final Map<Status, Image.Status> toPortableImageStatus;
    private final FindLocationForResource findLocationForResource;
    private final PopulateDefaultLoginCredentialsForImageStrategy credentialsProvider;
    private final Function<String, OperatingSystem> osParser;
    private ReferenceType parent;

    @Inject
    protected ImageForVCloudExpressVAppTemplate(Map<Status, Image.Status> toPortableImageStatus, FindLocationForResource findLocationForResource, PopulateDefaultLoginCredentialsForImageStrategy credentialsProvider, Function<String, OperatingSystem> osParser) {
        this.toPortableImageStatus = Preconditions.checkNotNull(toPortableImageStatus, "toPortableImageStatus");
        this.findLocationForResource = Preconditions.checkNotNull(findLocationForResource, "findLocationForResource");
        this.credentialsProvider = Preconditions.checkNotNull(credentialsProvider, "credentialsProvider");
        this.osParser = osParser;
    }

    public ImageForVCloudExpressVAppTemplate withParent(ReferenceType parent) {
        this.parent = parent;
        return this;
    }

    @Override
    public Image apply(VAppTemplate from) {
        ImageBuilder builder = new ImageBuilder();
        builder.ids(from.getHref().toASCIIString());
        builder.uri(from.getHref());
        builder.name(from.getName());
        builder.location(this.findLocationForResource.apply(Preconditions.checkNotNull(this.parent, "parent")));
        builder.description(from.getDescription() != null ? from.getDescription() : from.getName());
        builder.operatingSystem(this.osParser.apply(from.getName()));
        builder.status(this.toPortableImageStatus.get((Object)from.getStatus()));
        builder.defaultCredentials(this.credentialsProvider.apply(from));
        return builder.build();
    }
}

