/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.softlayer.domain;

import com.google.common.base.CaseFormat;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import java.beans.ConstructorProperties;
import java.util.Date;
import org.jclouds.javax.annotation.Nullable;
import org.jclouds.softlayer.domain.Datacenter;
import org.jclouds.softlayer.domain.OperatingSystem;
import org.jclouds.softlayer.domain.PowerState;

public class VirtualGuest {
    private final int accountId;
    private final Date createDate;
    private final boolean dedicatedAccountHostOnly;
    private final String domain;
    private final String fullyQualifiedDomainName;
    private final String hostname;
    private final int id;
    private final Date lastVerifiedDate;
    private final int maxCpu;
    private final String maxCpuUnits;
    private final int maxMemory;
    private final Date metricPollDate;
    private final Date modifyDate;
    private final String notes;
    private final boolean privateNetworkOnly;
    private final int startCpus;
    private final int statusId;
    private final String uuid;
    private final String primaryBackendIpAddress;
    private final String primaryIpAddress;
    private final int billingItemId;
    private final OperatingSystem operatingSystem;
    private final Datacenter datacenter;
    private final PowerState powerState;

    public static Builder<?> builder() {
        return new ConcreteBuilder();
    }

    public Builder<?> toBuilder() {
        return new ConcreteBuilder().fromVirtualGuest(this);
    }

    @ConstructorProperties(value={"accountId", "createDate", "dedicatedAccountHostOnlyFlag", "domain", "fullyQualifiedDomainName", "hostname", "id", "lastVerifiedDate", "maxCpu", "maxCpuUnits", "maxMemory", "metricPollDate", "modifyDate", "notes", "privateNetworkOnlyFlag", "startCpus", "statusId", "uuid", "primaryBackendIpAddress", "primaryIpAddress", "billingItem", "operatingSystem", "datacenter", "powerState"})
    protected VirtualGuest(int accountId, @Nullable Date createDate, boolean dedicatedAccountHostOnly, @Nullable String domain, @Nullable String fullyQualifiedDomainName, @Nullable String hostname, int id, @Nullable Date lastVerifiedDate, int maxCpu, @Nullable String maxCpuUnits, int maxMemory, @Nullable Date metricPollDate, @Nullable Date modifyDate, @Nullable String notes, boolean privateNetworkOnly, int startCpus, int statusId, @Nullable String uuid, @Nullable String primaryBackendIpAddress, @Nullable String primaryIpAddress, @Nullable BillingItem billingItem, @Nullable OperatingSystem operatingSystem, @Nullable Datacenter datacenter, @Nullable PowerState powerState) {
        this.accountId = accountId;
        this.createDate = createDate;
        this.dedicatedAccountHostOnly = dedicatedAccountHostOnly;
        this.domain = domain;
        this.fullyQualifiedDomainName = fullyQualifiedDomainName;
        this.hostname = hostname;
        this.id = id;
        this.lastVerifiedDate = lastVerifiedDate;
        this.maxCpu = maxCpu;
        this.maxCpuUnits = maxCpuUnits;
        this.maxMemory = maxMemory;
        this.metricPollDate = metricPollDate;
        this.modifyDate = modifyDate;
        this.notes = notes;
        this.privateNetworkOnly = privateNetworkOnly;
        this.startCpus = startCpus;
        this.statusId = statusId;
        this.uuid = uuid;
        this.primaryBackendIpAddress = primaryBackendIpAddress;
        this.primaryIpAddress = primaryIpAddress;
        this.billingItemId = billingItem == null ? -1 : billingItem.id;
        this.operatingSystem = operatingSystem;
        this.datacenter = datacenter;
        this.powerState = powerState;
    }

    public int getAccountId() {
        return this.accountId;
    }

    @Nullable
    public Date getCreateDate() {
        return this.createDate;
    }

    public boolean isDedicatedAccountHostOnly() {
        return this.dedicatedAccountHostOnly;
    }

    @Nullable
    public String getDomain() {
        return this.domain;
    }

    @Nullable
    public String getFullyQualifiedDomainName() {
        return this.fullyQualifiedDomainName;
    }

    @Nullable
    public String getHostname() {
        return this.hostname;
    }

    public int getId() {
        return this.id;
    }

    @Nullable
    public Date getLastVerifiedDate() {
        return this.lastVerifiedDate;
    }

    public int getMaxCpu() {
        return this.maxCpu;
    }

    @Nullable
    public String getMaxCpuUnits() {
        return this.maxCpuUnits;
    }

    public int getMaxMemory() {
        return this.maxMemory;
    }

    @Nullable
    public Date getMetricPollDate() {
        return this.metricPollDate;
    }

    @Nullable
    public Date getModifyDate() {
        return this.modifyDate;
    }

    @Nullable
    public String getNotes() {
        return this.notes;
    }

    public boolean isPrivateNetworkOnly() {
        return this.privateNetworkOnly;
    }

    public int getStartCpus() {
        return this.startCpus;
    }

    public int getStatusId() {
        return this.statusId;
    }

    @Nullable
    public String getUuid() {
        return this.uuid;
    }

    @Nullable
    public String getPrimaryBackendIpAddress() {
        return this.primaryBackendIpAddress;
    }

    @Nullable
    public String getPrimaryIpAddress() {
        return this.primaryIpAddress;
    }

    public int getBillingItemId() {
        return this.billingItemId;
    }

    @Nullable
    public OperatingSystem getOperatingSystem() {
        return this.operatingSystem;
    }

    @Nullable
    public Datacenter getDatacenter() {
        return this.datacenter;
    }

    @Nullable
    public PowerState getPowerState() {
        return this.powerState;
    }

    public int hashCode() {
        return Objects.hashCode(this.accountId, this.createDate, this.dedicatedAccountHostOnly, this.domain, this.fullyQualifiedDomainName, this.hostname, this.id, this.lastVerifiedDate, this.maxCpu, this.maxCpuUnits, this.maxMemory, this.metricPollDate, this.modifyDate, this.notes, this.privateNetworkOnly, this.startCpus, this.statusId, this.uuid, this.primaryBackendIpAddress, this.primaryIpAddress, this.billingItemId, this.operatingSystem, this.datacenter, this.powerState);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        VirtualGuest that = (VirtualGuest)VirtualGuest.class.cast(obj);
        return Objects.equal(this.accountId, that.accountId) && Objects.equal(this.createDate, that.createDate) && Objects.equal(this.dedicatedAccountHostOnly, that.dedicatedAccountHostOnly) && Objects.equal(this.domain, that.domain) && Objects.equal(this.fullyQualifiedDomainName, that.fullyQualifiedDomainName) && Objects.equal(this.hostname, that.hostname) && Objects.equal(this.id, that.id) && Objects.equal(this.lastVerifiedDate, that.lastVerifiedDate) && Objects.equal(this.maxCpu, that.maxCpu) && Objects.equal(this.maxCpuUnits, that.maxCpuUnits) && Objects.equal(this.maxMemory, that.maxMemory) && Objects.equal(this.metricPollDate, that.metricPollDate) && Objects.equal(this.modifyDate, that.modifyDate) && Objects.equal(this.notes, that.notes) && Objects.equal(this.privateNetworkOnly, that.privateNetworkOnly) && Objects.equal(this.startCpus, that.startCpus) && Objects.equal(this.statusId, that.statusId) && Objects.equal(this.uuid, that.uuid) && Objects.equal(this.primaryBackendIpAddress, that.primaryBackendIpAddress) && Objects.equal(this.primaryIpAddress, that.primaryIpAddress) && Objects.equal(this.billingItemId, that.billingItemId) && Objects.equal(this.operatingSystem, that.operatingSystem) && Objects.equal(this.datacenter, that.datacenter) && Objects.equal(this.powerState, that.powerState);
    }

    protected Objects.ToStringHelper string() {
        return Objects.toStringHelper(this).add("accountId", this.accountId).add("createDate", this.createDate).add("dedicatedAccountHostOnly", this.dedicatedAccountHostOnly).add("domain", this.domain).add("fullyQualifiedDomainName", this.fullyQualifiedDomainName).add("hostname", this.hostname).add("id", this.id).add("lastVerifiedDate", this.lastVerifiedDate).add("maxCpu", this.maxCpu).add("maxCpuUnits", this.maxCpuUnits).add("maxMemory", this.maxMemory).add("metricPollDate", this.metricPollDate).add("modifyDate", this.modifyDate).add("notes", this.notes).add("privateNetworkOnly", this.privateNetworkOnly).add("startCpus", this.startCpus).add("statusId", this.statusId).add("uuid", this.uuid).add("primaryBackendIpAddress", this.primaryBackendIpAddress).add("primaryIpAddress", this.primaryIpAddress).add("billingItemId", this.billingItemId).add("operatingSystem", this.operatingSystem).add("datacenter", this.datacenter).add("powerState", this.powerState);
    }

    public String toString() {
        return this.string().toString();
    }

    private static class ConcreteBuilder
    extends Builder<ConcreteBuilder> {
        private ConcreteBuilder() {
        }

        @Override
        protected ConcreteBuilder self() {
            return this;
        }
    }

    public static abstract class Builder<T extends Builder<T>> {
        protected int accountId;
        protected Date createDate;
        protected boolean dedicatedAccountHostOnly;
        protected String domain;
        protected String fullyQualifiedDomainName;
        protected String hostname;
        protected int id;
        protected Date lastVerifiedDate;
        protected int maxCpu;
        protected String maxCpuUnits;
        protected int maxMemory;
        protected Date metricPollDate;
        protected Date modifyDate;
        protected String notes;
        protected boolean privateNetworkOnly;
        protected int startCpus;
        protected int statusId;
        protected String uuid;
        protected String primaryBackendIpAddress;
        protected String primaryIpAddress;
        protected int billingItemId;
        protected OperatingSystem operatingSystem;
        protected Datacenter datacenter;
        protected PowerState powerState;

        protected abstract T self();

        public T accountId(int accountId) {
            this.accountId = accountId;
            return this.self();
        }

        public T createDate(Date createDate) {
            this.createDate = createDate;
            return this.self();
        }

        public T dedicatedAccountHostOnly(boolean dedicatedAccountHostOnly) {
            this.dedicatedAccountHostOnly = dedicatedAccountHostOnly;
            return this.self();
        }

        public T domain(String domain) {
            this.domain = domain;
            return this.self();
        }

        public T fullyQualifiedDomainName(String fullyQualifiedDomainName) {
            this.fullyQualifiedDomainName = fullyQualifiedDomainName;
            return this.self();
        }

        public T hostname(String hostname) {
            this.hostname = hostname;
            return this.self();
        }

        public T id(int id) {
            this.id = id;
            return this.self();
        }

        public T lastVerifiedDate(Date lastVerifiedDate) {
            this.lastVerifiedDate = lastVerifiedDate;
            return this.self();
        }

        public T maxCpu(int maxCpu) {
            this.maxCpu = maxCpu;
            return this.self();
        }

        public T maxCpuUnits(String maxCpuUnits) {
            this.maxCpuUnits = maxCpuUnits;
            return this.self();
        }

        public T maxMemory(int maxMemory) {
            this.maxMemory = maxMemory;
            return this.self();
        }

        public T metricPollDate(Date metricPollDate) {
            this.metricPollDate = metricPollDate;
            return this.self();
        }

        public T modifyDate(Date modifyDate) {
            this.modifyDate = modifyDate;
            return this.self();
        }

        public T notes(String notes) {
            this.notes = notes;
            return this.self();
        }

        public T privateNetworkOnly(boolean privateNetworkOnly) {
            this.privateNetworkOnly = privateNetworkOnly;
            return this.self();
        }

        public T startCpus(int startCpus) {
            this.startCpus = startCpus;
            return this.self();
        }

        public T statusId(int statusId) {
            this.statusId = statusId;
            return this.self();
        }

        public T uuid(String uuid) {
            this.uuid = uuid;
            return this.self();
        }

        public T primaryBackendIpAddress(String primaryBackendIpAddress) {
            this.primaryBackendIpAddress = primaryBackendIpAddress;
            return this.self();
        }

        public T primaryIpAddress(String primaryIpAddress) {
            this.primaryIpAddress = primaryIpAddress;
            return this.self();
        }

        public T billingItemId(int billingItemId) {
            this.billingItemId = billingItemId;
            return this.self();
        }

        public T operatingSystem(OperatingSystem operatingSystem) {
            this.operatingSystem = operatingSystem;
            return this.self();
        }

        public T datacenter(Datacenter datacenter) {
            this.datacenter = datacenter;
            return this.self();
        }

        public T powerState(PowerState powerState) {
            this.powerState = powerState;
            return this.self();
        }

        public VirtualGuest build() {
            return new VirtualGuest(this.accountId, this.createDate, this.dedicatedAccountHostOnly, this.domain, this.fullyQualifiedDomainName, this.hostname, this.id, this.lastVerifiedDate, this.maxCpu, this.maxCpuUnits, this.maxMemory, this.metricPollDate, this.modifyDate, this.notes, this.privateNetworkOnly, this.startCpus, this.statusId, this.uuid, this.primaryBackendIpAddress, this.primaryIpAddress, new BillingItem(this.billingItemId), this.operatingSystem, this.datacenter, this.powerState);
        }

        public T fromVirtualGuest(VirtualGuest in) {
            return ((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)this.accountId(in.getAccountId())).createDate(in.getCreateDate())).dedicatedAccountHostOnly(in.isDedicatedAccountHostOnly())).domain(in.getDomain())).fullyQualifiedDomainName(in.getFullyQualifiedDomainName())).hostname(in.getHostname())).id(in.getId())).lastVerifiedDate(in.getLastVerifiedDate())).maxCpu(in.getMaxCpu())).maxCpuUnits(in.getMaxCpuUnits())).maxMemory(in.getMaxMemory())).metricPollDate(in.getMetricPollDate())).modifyDate(in.getModifyDate())).notes(in.getNotes())).privateNetworkOnly(in.isPrivateNetworkOnly())).startCpus(in.getStartCpus())).statusId(in.getStatusId())).uuid(in.getUuid())).primaryBackendIpAddress(in.getPrimaryBackendIpAddress())).primaryIpAddress(in.getPrimaryIpAddress())).billingItemId(in.getBillingItemId())).operatingSystem(in.getOperatingSystem())).datacenter(in.getDatacenter())).powerState(in.getPowerState());
        }
    }

    public static class BillingItem {
        private final int id;

        @ConstructorProperties(value={"id"})
        public BillingItem(int id) {
            this.id = id;
        }

        public String toString() {
            return "[id=" + this.id + "]";
        }
    }

    public static enum State {
        HALTED,
        PAUSED,
        RUNNING,
        UNRECOGNIZED;


        public String toString() {
            return CaseFormat.UPPER_UNDERSCORE.to(CaseFormat.UPPER_CAMEL, this.name());
        }

        public static State fromValue(String state) {
            try {
                return State.valueOf(CaseFormat.UPPER_CAMEL.to(CaseFormat.UPPER_UNDERSCORE, Preconditions.checkNotNull(state, "state")));
            }
            catch (IllegalArgumentException e) {
                return UNRECOGNIZED;
            }
        }
    }
}

