/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.softlayer.domain;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import java.beans.ConstructorProperties;
import org.jclouds.javax.annotation.Nullable;

public class Address {
    private final int id;
    private final String country;
    private final String state;
    private final String description;

    public static Builder<?> builder() {
        return new ConcreteBuilder();
    }

    public Builder<?> toBuilder() {
        return new ConcreteBuilder().fromAddress(this);
    }

    @ConstructorProperties(value={"id", "country", "state", "description"})
    protected Address(int id, String country, @Nullable String state, @Nullable String description) {
        this.id = id;
        this.country = Preconditions.checkNotNull(Strings.emptyToNull(country), "country cannot be null or empty:" + country);
        this.state = state;
        this.description = description;
    }

    public int getId() {
        return this.id;
    }

    public String getCountry() {
        return this.country;
    }

    @Nullable
    public String getState() {
        return this.state;
    }

    @Nullable
    public String getDescription() {
        return this.description;
    }

    public int hashCode() {
        return Objects.hashCode(this.id);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        Address that = (Address)Address.class.cast(obj);
        return Objects.equal(this.id, that.id);
    }

    protected Objects.ToStringHelper string() {
        return Objects.toStringHelper(this).add("id", this.id).add("country", this.country).add("state", this.state).add("description", this.description);
    }

    public String toString() {
        return this.string().toString();
    }

    private static class ConcreteBuilder
    extends Builder<ConcreteBuilder> {
        private ConcreteBuilder() {
        }

        @Override
        protected ConcreteBuilder self() {
            return this;
        }
    }

    public static abstract class Builder<T extends Builder<T>> {
        protected int id;
        protected String country;
        protected String state;
        protected String description;

        protected abstract T self();

        public T id(int id) {
            this.id = id;
            return this.self();
        }

        public T country(String country) {
            this.country = country;
            return this.self();
        }

        public T state(String state) {
            this.state = state;
            return this.self();
        }

        public T description(String description) {
            this.description = description;
            return this.self();
        }

        public Address build() {
            return new Address(this.id, this.country, this.state, this.description);
        }

        public T fromAddress(Address in) {
            return ((Builder)((Builder)((Builder)this.id(in.getId())).country(in.getCountry())).state(in.getState())).description(in.getDescription());
        }
    }
}

