/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.scriptbuilder;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import java.util.Map;
import org.jclouds.scriptbuilder.domain.OsFamily;
import org.jclouds.scriptbuilder.domain.ShellToken;
import org.jclouds.scriptbuilder.util.Utils;

public class EnvBuilder {
    @VisibleForTesting
    Map<String, String> variables = Maps.newHashMap();

    public EnvBuilder export(String name, String value) {
        this.variables.put(Preconditions.checkNotNull(name, "name"), Preconditions.checkNotNull(value, "value"));
        return this;
    }

    public String build(OsFamily osFamily) {
        StringBuilder builder = new StringBuilder();
        builder.append(Utils.writeComment(" Env file: please do not confuse people by making this executable", osFamily));
        builder.append(Utils.writeComment("", osFamily));
        builder.append(Utils.writeComment(" Example usage to set a variable", osFamily));
        builder.append(Utils.writeComment("", osFamily));
        builder.append(Utils.writeComment(" " + Utils.writeVariableExporters(ImmutableMap.of("MAVEN_OPTS", "-Xms64m -Xmx128m"), osFamily), osFamily));
        builder.append(Utils.writeVariableExporters(this.variables, osFamily));
        builder.append(ShellToken.LF.to(osFamily));
        builder.append(Utils.writeComment(" Please retain this statement so that the script can be validated", osFamily));
        builder.append(ShellToken.RETURN.to(osFamily)).append(" 0").append(ShellToken.LF.to(osFamily));
        return builder.toString();
    }
}

