/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.s3.blobstore;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Supplier;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.jclouds.blobstore.BlobStoreContext;
import org.jclouds.blobstore.ContainerNotFoundException;
import org.jclouds.blobstore.domain.Blob;
import org.jclouds.blobstore.domain.BlobMetadata;
import org.jclouds.blobstore.domain.PageSet;
import org.jclouds.blobstore.domain.StorageMetadata;
import org.jclouds.blobstore.functions.BlobToHttpGetOptions;
import org.jclouds.blobstore.internal.BaseBlobStore;
import org.jclouds.blobstore.options.CreateContainerOptions;
import org.jclouds.blobstore.options.ListContainerOptions;
import org.jclouds.blobstore.options.PutOptions;
import org.jclouds.blobstore.strategy.internal.FetchBlobMetadata;
import org.jclouds.blobstore.util.BlobUtils;
import org.jclouds.collect.Memoized;
import org.jclouds.domain.Location;
import org.jclouds.http.options.GetOptions;
import org.jclouds.s3.S3Client;
import org.jclouds.s3.blobstore.functions.BlobToObject;
import org.jclouds.s3.blobstore.functions.BucketToResourceList;
import org.jclouds.s3.blobstore.functions.ContainerToBucketListOptions;
import org.jclouds.s3.blobstore.functions.ObjectToBlob;
import org.jclouds.s3.blobstore.functions.ObjectToBlobMetadata;
import org.jclouds.s3.domain.AccessControlList;
import org.jclouds.s3.domain.BucketMetadata;
import org.jclouds.s3.domain.CannedAccessPolicy;
import org.jclouds.s3.options.ListBucketOptions;
import org.jclouds.s3.options.PutBucketOptions;
import org.jclouds.s3.options.PutObjectOptions;
import org.jclouds.s3.util.S3Utils;
import org.jclouds.util.Assertions;

@Singleton
public class S3BlobStore
extends BaseBlobStore {
    private final S3Client sync;
    private final Function<Set<BucketMetadata>, PageSet<? extends StorageMetadata>> convertBucketsToStorageMetadata;
    private final ContainerToBucketListOptions container2BucketListOptions;
    private final BucketToResourceList bucket2ResourceList;
    private final ObjectToBlob object2Blob;
    private final BlobToObject blob2Object;
    private final ObjectToBlobMetadata object2BlobMd;
    private final BlobToHttpGetOptions blob2ObjectGetOptions;
    private final Provider<FetchBlobMetadata> fetchBlobMetadataProvider;
    private final LoadingCache<String, AccessControlList> bucketAcls;

    @Inject
    protected S3BlobStore(BlobStoreContext context, BlobUtils blobUtils, Supplier<Location> defaultLocation, @Memoized Supplier<Set<? extends Location>> locations, S3Client sync, Function<Set<BucketMetadata>, PageSet<? extends StorageMetadata>> convertBucketsToStorageMetadata, ContainerToBucketListOptions container2BucketListOptions, BucketToResourceList bucket2ResourceList, ObjectToBlob object2Blob, BlobToHttpGetOptions blob2ObjectGetOptions, BlobToObject blob2Object, ObjectToBlobMetadata object2BlobMd, Provider<FetchBlobMetadata> fetchBlobMetadataProvider, LoadingCache<String, AccessControlList> bucketAcls) {
        super(context, blobUtils, defaultLocation, locations);
        this.blob2ObjectGetOptions = Preconditions.checkNotNull(blob2ObjectGetOptions, "blob2ObjectGetOptions");
        this.sync = Preconditions.checkNotNull(sync, "sync");
        this.convertBucketsToStorageMetadata = Preconditions.checkNotNull(convertBucketsToStorageMetadata, "convertBucketsToStorageMetadata");
        this.container2BucketListOptions = Preconditions.checkNotNull(container2BucketListOptions, "container2BucketListOptions");
        this.bucket2ResourceList = Preconditions.checkNotNull(bucket2ResourceList, "bucket2ResourceList");
        this.object2Blob = Preconditions.checkNotNull(object2Blob, "object2Blob");
        this.blob2Object = Preconditions.checkNotNull(blob2Object, "blob2Object");
        this.object2BlobMd = Preconditions.checkNotNull(object2BlobMd, "object2BlobMd");
        this.fetchBlobMetadataProvider = Preconditions.checkNotNull(fetchBlobMetadataProvider, "fetchBlobMetadataProvider");
        this.bucketAcls = Preconditions.checkNotNull(bucketAcls, "bucketAcls");
    }

    @Override
    public PageSet<? extends StorageMetadata> list() {
        return this.convertBucketsToStorageMetadata.apply(this.sync.listOwnedBuckets());
    }

    @Override
    public boolean containerExists(String container) {
        return this.sync.bucketExists(container);
    }

    @Override
    public boolean createContainerInLocation(Location location, String container) {
        return this.createContainerInLocation(location, container, CreateContainerOptions.NONE);
    }

    @Override
    public PageSet<? extends StorageMetadata> list(String container, ListContainerOptions options) {
        ListBucketOptions httpOptions = this.container2BucketListOptions.apply(options);
        PageSet<? extends StorageMetadata> list = this.bucket2ResourceList.apply(this.sync.listBucket(container, httpOptions));
        return options.isDetailed() ? this.fetchBlobMetadataProvider.get().setContainerName(container).apply(list) : list;
    }

    @Override
    public void deleteContainer(String container) {
        this.clearAndDeleteContainer(container);
    }

    @Override
    public void clearAndDeleteContainer(final String container) {
        try {
            if (!Assertions.eventuallyTrue(new Supplier<Boolean>(){

                @Override
                public Boolean get() {
                    try {
                        S3BlobStore.this.clearContainer(container);
                        return S3BlobStore.this.sync.deleteBucketIfEmpty(container);
                    }
                    catch (ContainerNotFoundException e) {
                        return true;
                    }
                }
            }, 30000L)) {
                throw new IllegalStateException(container + " still exists after deleting!");
            }
        }
        catch (InterruptedException e) {
            throw new IllegalStateException(container + " interrupted during deletion!", e);
        }
    }

    @Override
    public boolean blobExists(String container, String key) {
        return this.sync.objectExists(container, key);
    }

    @Override
    public BlobMetadata blobMetadata(String container, String key) {
        return this.object2BlobMd.apply(this.sync.headObject(container, key));
    }

    @Override
    public Blob getBlob(String container, String key, org.jclouds.blobstore.options.GetOptions optionsList) {
        GetOptions httpOptions = this.blob2ObjectGetOptions.apply(optionsList);
        return this.object2Blob.apply(this.sync.getObject(container, key, httpOptions));
    }

    @Override
    public String putBlob(String container, Blob blob) {
        return this.putBlob(container, blob, PutOptions.NONE);
    }

    @Override
    public String putBlob(String container, Blob blob, PutOptions overrides) {
        PutObjectOptions options = new PutObjectOptions();
        try {
            AccessControlList acl = this.bucketAcls.getUnchecked(container);
            if (acl != null && acl.hasPermission(AccessControlList.GroupGranteeURI.ALL_USERS, "READ")) {
                options.withAcl(CannedAccessPolicy.PUBLIC_READ);
            }
        }
        catch (CacheLoader.InvalidCacheLoadException e) {
            // empty catch block
        }
        return this.sync.putObject(container, this.blob2Object.apply(blob), options);
    }

    @Override
    public void removeBlob(String container, String key) {
        this.sync.deleteObject(container, key);
    }

    @Override
    protected boolean deleteAndVerifyContainerGone(String container) {
        return S3Utils.deleteAndVerifyContainerGone(this.sync, container);
    }

    @Override
    public boolean createContainerInLocation(Location location, String container, CreateContainerOptions options) {
        PutBucketOptions putBucketOptions = new PutBucketOptions();
        if (options.isPublicRead()) {
            putBucketOptions.withBucketAcl(CannedAccessPolicy.PUBLIC_READ);
        }
        location = location != null ? location : (Location)this.defaultLocation.get();
        return this.sync.putBucketInRegion(location.getId(), container, putBucketOptions);
    }
}

