/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.route53.functions;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import org.jclouds.route53.domain.RecordSet;

public class SerializeRRS
implements Function<Object, String> {
    @Override
    public String apply(Object in) {
        RecordSet rrs = (RecordSet)RecordSet.class.cast(Preconditions.checkNotNull(in, "rrs"));
        StringBuilder builder = new StringBuilder().append("<ResourceRecordSet>");
        builder.append("<Name>").append(rrs.getName()).append("</Name>");
        builder.append("<Type>").append((Object)rrs.getType()).append("</Type>");
        if (rrs instanceof RecordSet.RecordSubset) {
            String id = ((RecordSet.RecordSubset)RecordSet.RecordSubset.class.cast(rrs)).getId();
            builder.append("<ResourceRecordSubset>").append(id).append("</ResourceRecordSubset>");
        }
        if (rrs instanceof RecordSet.RecordSubset.Weighted) {
            builder.append("<Weight>").append(((RecordSet.RecordSubset.Weighted)RecordSet.RecordSubset.Weighted.class.cast(rrs)).getWeight()).append("</Weight>");
        }
        if (rrs instanceof RecordSet.RecordSubset.Latency) {
            builder.append("<Region>").append(((RecordSet.RecordSubset.Latency)RecordSet.RecordSubset.Latency.class.cast(rrs)).getRegion()).append("</Region>");
        }
        if (rrs.getAliasTarget().isPresent()) {
            builder.append("<AliasTarget>");
            builder.append("<HostedZoneId>").append(rrs.getAliasTarget().get().getZoneId()).append("</HostedZoneId>");
            builder.append("<DNSName>").append(rrs.getAliasTarget().get().getDNSName()).append("</DNSName>");
            builder.append("</AliasTarget>");
        } else {
            builder.append("<TTL>").append(rrs.getTTL().or(0)).append("</TTL>");
            builder.append("<ResourceRecords>");
            for (String record : rrs.getValues()) {
                builder.append("<ResourceRecord>").append("<Value>").append(record).append("</Value>").append("</ResourceRecord>");
            }
            builder.append("</ResourceRecords>");
        }
        return builder.append("</ResourceRecordSet>").toString();
    }
}

