/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.rackspace.cloudloadbalancers.predicates;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import java.util.concurrent.TimeUnit;
import org.jclouds.predicates.RetryablePredicate;
import org.jclouds.rackspace.cloudloadbalancers.domain.LoadBalancer;
import org.jclouds.rackspace.cloudloadbalancers.features.LoadBalancerApi;

public class LoadBalancerPredicates {
    public static RetryablePredicate<LoadBalancer> awaitAvailable(LoadBalancerApi loadBalancerApi) {
        StatusUpdatedPredicate statusPredicate = new StatusUpdatedPredicate(loadBalancerApi, LoadBalancer.Status.ACTIVE);
        return new RetryablePredicate<LoadBalancer>(statusPredicate, 300L, 3L, 3L, TimeUnit.SECONDS);
    }

    public static RetryablePredicate<LoadBalancer> awaitDeleted(LoadBalancerApi loadBalancerApi) {
        DeletedPredicate deletedPredicate = new DeletedPredicate(loadBalancerApi);
        return new RetryablePredicate<LoadBalancer>(deletedPredicate, 300L, 3L, 3L, TimeUnit.SECONDS);
    }

    public static RetryablePredicate<LoadBalancer> awaitStatus(LoadBalancerApi loadBalancerApi, LoadBalancer.Status status, long maxWaitInSec, long periodInSec) {
        StatusUpdatedPredicate statusPredicate = new StatusUpdatedPredicate(loadBalancerApi, status);
        return new RetryablePredicate<LoadBalancer>(statusPredicate, maxWaitInSec, periodInSec, periodInSec, TimeUnit.SECONDS);
    }

    private static class DeletedPredicate
    implements Predicate<LoadBalancer> {
        private LoadBalancerApi loadBalancerApi;

        public DeletedPredicate(LoadBalancerApi loadBalancerApi) {
            this.loadBalancerApi = Preconditions.checkNotNull(loadBalancerApi, "loadBalancerApi must be defined");
        }

        @Override
        public boolean apply(LoadBalancer loadBalancer) {
            Preconditions.checkNotNull(loadBalancer, "loadBalancer must be defined");
            LoadBalancer loadBalancerUpdate = this.loadBalancerApi.get(loadBalancer.getId());
            if (loadBalancerUpdate == null) {
                return true;
            }
            return loadBalancerUpdate.getStatus().equals((Object)LoadBalancer.Status.DELETED);
        }
    }

    private static class StatusUpdatedPredicate
    implements Predicate<LoadBalancer> {
        private LoadBalancerApi loadBalancerApi;
        private LoadBalancer.Status status;

        public StatusUpdatedPredicate(LoadBalancerApi loadBalancerApi, LoadBalancer.Status status) {
            this.loadBalancerApi = Preconditions.checkNotNull(loadBalancerApi, "loadBalancerApi must be defined");
            this.status = Preconditions.checkNotNull(status, "status must be defined");
        }

        @Override
        public boolean apply(LoadBalancer loadBalancer) {
            Preconditions.checkNotNull(loadBalancer, "loadBalancer must be defined");
            LoadBalancer loadBalancerUpdated = this.loadBalancerApi.get(loadBalancer.getId());
            Preconditions.checkNotNull(loadBalancerUpdated, "LoadBalancer %s not found.", loadBalancer.getId());
            return this.status.equals((Object)loadBalancerUpdated.getStatus());
        }
    }
}

