/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.rackspace.cloudloadbalancers.domain;

import com.google.common.base.Objects;
import org.jclouds.rackspace.cloudloadbalancers.domain.internal.BaseNode;

public class NodeRequest
extends BaseNode<NodeRequest> {
    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().from(this);
    }

    NodeRequest() {
    }

    public NodeRequest(String address, int port, BaseNode.Condition condition, Integer weight) {
        super(address, port, condition, weight);
    }

    @Override
    protected Objects.ToStringHelper string() {
        return Objects.toStringHelper(this).omitNullValues().add("address", this.address).add("port", this.port).add("condition", (Object)this.condition).add("weight", this.weight);
    }

    @Override
    public String toString() {
        return this.string().toString();
    }

    @Override
    public int hashCode() {
        return Objects.hashCode(this.address, this.port);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        NodeRequest that = (NodeRequest)NodeRequest.class.cast(obj);
        return Objects.equal(this.address, that.address) && Objects.equal(this.port, that.port);
    }

    public static class Builder
    extends BaseNode.Builder<NodeRequest> {
        public NodeRequest build() {
            return new NodeRequest(this.address, this.port, this.condition, this.weight);
        }

        public Builder address(String address) {
            return (Builder)Builder.class.cast(super.address(address));
        }

        public Builder condition(BaseNode.Condition condition) {
            return (Builder)Builder.class.cast(super.condition(condition));
        }

        public Builder from(NodeRequest in) {
            return (Builder)Builder.class.cast(super.from(in));
        }

        public Builder port(int port) {
            return (Builder)Builder.class.cast(super.port(port));
        }

        public Builder weight(Integer weight) {
            return (Builder)Builder.class.cast(super.weight(weight));
        }
    }
}

