/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.swift.domain;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.beans.ConstructorProperties;
import java.util.Map;
import org.jclouds.javax.annotation.Nullable;

public class ContainerMetadata {
    private final String name;
    private final long count;
    private final long bytes;
    private final String readACL;
    private final Map<String, String> metadata;

    public static Builder<?> builder() {
        return new ConcreteBuilder();
    }

    public Builder<?> toBuilder() {
        return new ConcreteBuilder().fromContainerMetadata(this);
    }

    @ConstructorProperties(value={"name", "count", "bytes", "X-Container-Read", "metadata"})
    protected ContainerMetadata(String name, long count, long bytes, @Nullable String readACL, @Nullable Map<String, String> metadata) {
        this.name = Preconditions.checkNotNull(name, "name");
        this.count = count;
        this.bytes = bytes;
        this.readACL = readACL;
        this.metadata = metadata == null ? ImmutableMap.of() : ImmutableMap.copyOf(metadata);
    }

    public String getName() {
        return this.name;
    }

    public long getCount() {
        return this.count;
    }

    public long getBytes() {
        return this.bytes;
    }

    @Nullable
    public String getReadACL() {
        return this.readACL;
    }

    public Map<String, String> getMetadata() {
        return this.metadata;
    }

    public int hashCode() {
        return Objects.hashCode(this.name, this.count, this.bytes);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        ContainerMetadata that = (ContainerMetadata)ContainerMetadata.class.cast(obj);
        return Objects.equal(this.name, that.name) && Objects.equal(this.count, that.count) && Objects.equal(this.bytes, that.bytes);
    }

    protected Objects.ToStringHelper string() {
        return Objects.toStringHelper(this).add("name", this.name).add("count", this.count).add("bytes", this.bytes).add("readACL", this.readACL).add("metadata", this.metadata);
    }

    public String toString() {
        return this.string().toString();
    }

    private static class ConcreteBuilder
    extends Builder<ConcreteBuilder> {
        private ConcreteBuilder() {
        }

        @Override
        protected ConcreteBuilder self() {
            return this;
        }
    }

    public static abstract class Builder<T extends Builder<T>> {
        protected String name;
        protected long count;
        protected long bytes;
        protected String readACL;
        protected Map<String, String> metadata = ImmutableMap.of();

        protected abstract T self();

        public T name(String name) {
            this.name = name;
            return this.self();
        }

        public T count(long count) {
            this.count = count;
            return this.self();
        }

        public T bytes(long bytes) {
            this.bytes = bytes;
            return this.self();
        }

        public T readACL(String readACL) {
            this.readACL = readACL;
            return this.self();
        }

        public T metadata(Map<String, String> metadata) {
            this.metadata = ImmutableMap.copyOf(Preconditions.checkNotNull(metadata, "metadata"));
            return this.self();
        }

        public ContainerMetadata build() {
            return new ContainerMetadata(this.name, this.count, this.bytes, this.readACL, this.metadata);
        }

        public T fromContainerMetadata(ContainerMetadata in) {
            return ((Builder)((Builder)((Builder)((Builder)this.name(in.getName())).count(in.getCount())).bytes(in.getBytes())).readACL(in.getReadACL())).metadata(in.getMetadata());
        }
    }
}

