/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.swift.blobstore.strategy.internal;

import com.google.common.base.Preconditions;
import com.google.inject.Inject;
import javax.annotation.Resource;
import javax.inject.Named;
import org.jclouds.blobstore.domain.Blob;
import org.jclouds.blobstore.options.PutOptions;
import org.jclouds.io.Payload;
import org.jclouds.io.PayloadSlicer;
import org.jclouds.logging.Logger;
import org.jclouds.openstack.swift.CommonSwiftClient;
import org.jclouds.openstack.swift.SwiftApiMetadata;
import org.jclouds.openstack.swift.blobstore.SwiftBlobStore;
import org.jclouds.openstack.swift.blobstore.functions.BlobToObject;
import org.jclouds.openstack.swift.blobstore.strategy.internal.MultipartUploadSlicingAlgorithm;
import org.jclouds.openstack.swift.blobstore.strategy.internal.MultipartUploadStrategy;
import org.jclouds.util.Throwables2;

public class SequentialMultipartUploadStrategy
implements MultipartUploadStrategy {
    public static final String PART_SEPARATOR = "/";
    @Resource
    @Named(value="jclouds.blobstore")
    protected Logger logger = Logger.NULL;
    protected final SwiftBlobStore ablobstore;
    protected final PayloadSlicer slicer;

    @Inject
    public SequentialMultipartUploadStrategy(SwiftBlobStore ablobstore, PayloadSlicer slicer) {
        this.ablobstore = Preconditions.checkNotNull(ablobstore, "ablobstore");
        this.slicer = Preconditions.checkNotNull(slicer, "slicer");
    }

    @Override
    public String execute(String container, Blob blob, PutOptions options, BlobToObject blob2Object) {
        String key = blob.getMetadata().getName();
        Payload payload = blob.getPayload();
        MultipartUploadSlicingAlgorithm algorithm = new MultipartUploadSlicingAlgorithm();
        algorithm.calculateChunkSize(Preconditions.checkNotNull(payload.getContentMetadata().getContentLength(), "contentLength required on all uploads to swift; please invoke payload.getContentMetadata().setContentLength(length) first"));
        int parts = algorithm.getParts();
        long chunkSize = algorithm.getChunkSize();
        if (parts > 0) {
            CommonSwiftClient client = this.ablobstore.getContext().unwrap(SwiftApiMetadata.CONTEXT_TOKEN).getApi();
            try {
                int part;
                while ((part = algorithm.getNextPart()) <= parts) {
                    Payload chunkedPart = this.slicer.slice(payload, algorithm.getNextChunkOffset(), chunkSize);
                    Blob blobPart = this.ablobstore.blobBuilder(blob.getMetadata().getName() + PART_SEPARATOR + String.valueOf(part)).payload(chunkedPart).contentDisposition(blob.getMetadata().getName() + PART_SEPARATOR + String.valueOf(part)).build();
                    client.putObject(container, blob2Object.apply(blobPart));
                }
                long remaining = algorithm.getRemaining();
                if (remaining > 0L) {
                    Payload chunkedPart = this.slicer.slice(payload, algorithm.getNextChunkOffset(), remaining);
                    Blob blobPart = this.ablobstore.blobBuilder(blob.getMetadata().getName() + PART_SEPARATOR + String.valueOf(part)).payload(chunkedPart).contentDisposition(blob.getMetadata().getName() + PART_SEPARATOR + String.valueOf(part)).build();
                    client.putObject(container, blob2Object.apply(blobPart));
                }
                return client.putObjectManifest(container, key);
            }
            catch (Exception ex) {
                RuntimeException rtex = Throwables2.getFirstThrowableOfType(ex, RuntimeException.class);
                if (rtex == null) {
                    rtex = new RuntimeException(ex);
                }
                throw rtex;
            }
        }
        return this.ablobstore.putBlob(container, blob, PutOptions.NONE);
    }
}

