/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.swift.blobstore;

import com.google.common.base.Preconditions;
import com.google.common.base.Supplier;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableSet;
import com.google.inject.Provider;
import java.lang.reflect.Method;
import java.security.InvalidKeyException;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.jclouds.blobstore.BlobRequestSigner;
import org.jclouds.blobstore.domain.Blob;
import org.jclouds.blobstore.functions.BlobToHttpGetOptions;
import org.jclouds.blobstore.util.BlobStoreUtils;
import org.jclouds.crypto.Crypto;
import org.jclouds.crypto.CryptoStreams;
import org.jclouds.date.TimeStamp;
import org.jclouds.http.HttpRequest;
import org.jclouds.http.HttpRequestFilter;
import org.jclouds.http.options.GetOptions;
import org.jclouds.openstack.swift.CommonSwiftAsyncClient;
import org.jclouds.openstack.swift.TemporaryUrlKey;
import org.jclouds.openstack.swift.blobstore.functions.BlobToObject;
import org.jclouds.openstack.swift.domain.SwiftObject;
import org.jclouds.rest.internal.GeneratedHttpRequest;
import org.jclouds.rest.internal.RestAnnotationProcessor;

@Singleton
public class SwiftBlobSigner<T extends CommonSwiftAsyncClient>
implements BlobRequestSigner {
    private final RestAnnotationProcessor<T> processor;
    private final Crypto crypto;
    private final Provider<Long> unixEpochTimestampProvider;
    private final Supplier<String> temporaryUrlKeySupplier;
    private final BlobToObject blobToObject;
    private final BlobToHttpGetOptions blob2HttpGetOptions;
    private final Method getMethod;
    private final Method deleteMethod;
    private final Method createMethod;

    @Inject
    protected SwiftBlobSigner(BlobToObject blobToObject, BlobToHttpGetOptions blob2HttpGetOptions, Crypto crypto, @TimeStamp Provider<Long> unixEpochTimestampProvider, @TemporaryUrlKey Supplier<String> temporaryUrlKeySupplier, RestAnnotationProcessor<T> processor) throws SecurityException, NoSuchMethodException {
        this.processor = Preconditions.checkNotNull(processor, "processor");
        this.crypto = Preconditions.checkNotNull(crypto, "crypto");
        this.unixEpochTimestampProvider = Preconditions.checkNotNull(unixEpochTimestampProvider, "unixEpochTimestampProvider");
        this.temporaryUrlKeySupplier = Preconditions.checkNotNull(temporaryUrlKeySupplier, "temporaryUrlKeyProvider");
        this.blobToObject = Preconditions.checkNotNull(blobToObject, "blobToObject");
        this.blob2HttpGetOptions = Preconditions.checkNotNull(blob2HttpGetOptions, "blob2HttpGetOptions");
        this.getMethod = processor.getDeclaring().getMethod("getObject", String.class, String.class, GetOptions[].class);
        this.deleteMethod = processor.getDeclaring().getMethod("removeObject", String.class, String.class);
        this.createMethod = processor.getDeclaring().getMethod("putObject", String.class, SwiftObject.class);
    }

    @Override
    public HttpRequest signGetBlob(String container, String name) {
        return BlobStoreUtils.cleanRequest(this.processor.createRequest(this.getMethod, container, name));
    }

    @Override
    public HttpRequest signGetBlob(String container, String name, long timeInSeconds) {
        GeneratedHttpRequest request = this.processor.createRequest(this.getMethod, container, name);
        return BlobStoreUtils.cleanRequest(this.signForTemporaryAccess(request, timeInSeconds));
    }

    @Override
    public HttpRequest signGetBlob(String container, String name, org.jclouds.blobstore.options.GetOptions options) {
        return BlobStoreUtils.cleanRequest(this.processor.createRequest(this.getMethod, container, name, this.blob2HttpGetOptions.apply(options)));
    }

    @Override
    public HttpRequest signPutBlob(String container, Blob blob) {
        return BlobStoreUtils.cleanRequest(this.processor.createRequest(this.createMethod, container, this.blobToObject.apply(blob)));
    }

    @Override
    public HttpRequest signPutBlob(String container, Blob blob, long timeInSeconds) {
        GeneratedHttpRequest request = this.processor.createRequest(this.createMethod, container, this.blobToObject.apply(blob));
        return BlobStoreUtils.cleanRequest(this.signForTemporaryAccess(request, timeInSeconds));
    }

    @Override
    public HttpRequest signRemoveBlob(String container, String name) {
        return BlobStoreUtils.cleanRequest(this.processor.createRequest(this.deleteMethod, container, name));
    }

    private HttpRequest signForTemporaryAccess(HttpRequest request, long timeInSeconds) {
        Object builder = ((HttpRequest.Builder)request.toBuilder()).filters(ImmutableSet.<HttpRequestFilter>of());
        String key = this.temporaryUrlKeySupplier.get();
        if (key == null) {
            throw new UnsupportedOperationException();
        }
        long expiresInSeconds = this.unixEpochTimestampProvider.get() + timeInSeconds;
        ((HttpRequest.Builder)builder).addQueryParam("temp_url_sig", this.createSignature(key, this.createStringToSign(request.getMethod().toUpperCase(), request, expiresInSeconds)));
        ((HttpRequest.Builder)builder).addQueryParam("temp_url_expires", "" + expiresInSeconds);
        return ((HttpRequest.Builder)builder).build();
    }

    private String createStringToSign(String method, HttpRequest request, long expiresInSeconds) {
        Preconditions.checkArgument(method.equalsIgnoreCase("GET") || method.equalsIgnoreCase("PUT"));
        return String.format("%s\n%d\n%s", method.toUpperCase(), expiresInSeconds, request.getEndpoint().getPath());
    }

    private String createSignature(String key, String stringToSign) {
        try {
            return CryptoStreams.hex(this.crypto.hmacSHA1(key.getBytes()).doFinal(stringToSign.getBytes()));
        }
        catch (InvalidKeyException e) {
            throw Throwables.propagate(e);
        }
    }
}

