/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.nova.v2_0.domain.zonescoped;

import com.google.common.base.Function;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.collect.Iterables;

public class ZoneAndName {
    public static final Function<ZoneAndName, String> NAME_FUNCTION = new Function<ZoneAndName, String>(){

        @Override
        public String apply(ZoneAndName input) {
            return input.getName();
        }
    };
    public static final Function<ZoneAndName, String> ZONE_FUNCTION = new Function<ZoneAndName, String>(){

        @Override
        public String apply(ZoneAndName input) {
            return input.getZone();
        }
    };
    protected final String zoneId;
    protected final String name;

    public static ZoneAndName fromSlashEncoded(String name) {
        Iterable<String> parts = Splitter.on('/').split(Preconditions.checkNotNull(name, "name"));
        Preconditions.checkArgument(Iterables.size(parts) == 2, "name must be in format zoneId/name");
        return new ZoneAndName(Iterables.get(parts, 0), Iterables.get(parts, 1));
    }

    public static ZoneAndName fromZoneAndName(String zoneId, String name) {
        return new ZoneAndName(zoneId, name);
    }

    private static String slashEncodeZoneAndName(String zoneId, String name) {
        return Preconditions.checkNotNull(zoneId, "zoneId") + "/" + Preconditions.checkNotNull(name, "name");
    }

    public String slashEncode() {
        return ZoneAndName.slashEncodeZoneAndName(this.zoneId, this.name);
    }

    protected ZoneAndName(String zoneId, String name) {
        this.zoneId = Preconditions.checkNotNull(zoneId, "zoneId");
        this.name = Preconditions.checkNotNull(name, "name");
    }

    public String getZone() {
        return this.zoneId;
    }

    public String getName() {
        return this.name;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ZoneAndName that = (ZoneAndName)ZoneAndName.class.cast(o);
        return Objects.equal(this.zoneId, that.zoneId) && Objects.equal(this.name, that.name);
    }

    public int hashCode() {
        return Objects.hashCode(this.zoneId, this.name);
    }

    public String toString() {
        return this.string().toString();
    }

    protected Objects.ToStringHelper string() {
        return Objects.toStringHelper("").add("zoneId", this.zoneId).add("name", this.name);
    }
}

