/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.nova.v2_0.compute.options;

import com.google.common.base.Objects;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import java.util.Arrays;
import java.util.Map;
import java.util.Set;
import org.jclouds.compute.options.TemplateOptions;
import org.jclouds.domain.LoginCredentials;
import org.jclouds.scriptbuilder.domain.Statement;
import org.jclouds.util.Preconditions2;

public class NovaTemplateOptions
extends TemplateOptions
implements Cloneable {
    protected boolean autoAssignFloatingIp = false;
    protected Optional<Set<String>> securityGroupNames = Optional.absent();
    protected boolean generateKeyPair = false;
    protected String keyPairName;
    protected byte[] userData;
    public static final NovaTemplateOptions NONE = new NovaTemplateOptions();

    @Override
    public NovaTemplateOptions clone() {
        NovaTemplateOptions options = new NovaTemplateOptions();
        this.copyTo(options);
        return options;
    }

    @Override
    public void copyTo(TemplateOptions to) {
        super.copyTo(to);
        if (to instanceof NovaTemplateOptions) {
            NovaTemplateOptions eTo = (NovaTemplateOptions)NovaTemplateOptions.class.cast(to);
            eTo.autoAssignFloatingIp(this.shouldAutoAssignFloatingIp());
            if (this.getSecurityGroupNames().isPresent()) {
                eTo.securityGroupNames((Iterable<String>)this.getSecurityGroupNames().get());
            }
            eTo.generateKeyPair(this.shouldGenerateKeyPair());
            eTo.keyPairName(this.getKeyPairName());
            if (this.getUserData() != null) {
                eTo.userData(this.getUserData());
            }
        }
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NovaTemplateOptions that = (NovaTemplateOptions)NovaTemplateOptions.class.cast(o);
        return super.equals(that) && Objects.equal(this.autoAssignFloatingIp, that.autoAssignFloatingIp) && Objects.equal(this.securityGroupNames, that.securityGroupNames) && Objects.equal(this.generateKeyPair, that.generateKeyPair) && Objects.equal(this.keyPairName, that.keyPairName) && Arrays.equals(this.userData, that.userData);
    }

    @Override
    public int hashCode() {
        return Objects.hashCode(super.hashCode(), this.autoAssignFloatingIp, this.securityGroupNames, this.generateKeyPair, this.keyPairName, this.userData);
    }

    @Override
    public Objects.ToStringHelper string() {
        Objects.ToStringHelper toString = super.string();
        if (!this.autoAssignFloatingIp) {
            toString.add("autoAssignFloatingIp", this.autoAssignFloatingIp);
        }
        if (this.securityGroupNames.isPresent()) {
            toString.add("securityGroupNames", this.securityGroupNames.get());
        }
        if (this.generateKeyPair) {
            toString.add("generateKeyPair", this.generateKeyPair);
        }
        toString.add("keyPairName", this.keyPairName);
        toString.add("userData", this.userData);
        return toString;
    }

    public NovaTemplateOptions autoAssignFloatingIp(boolean enable) {
        this.autoAssignFloatingIp = enable;
        return this;
    }

    public NovaTemplateOptions generateKeyPair(boolean enable) {
        this.generateKeyPair = enable;
        return this;
    }

    public NovaTemplateOptions keyPairName(String keyPairName) {
        this.keyPairName = keyPairName;
        return this;
    }

    public NovaTemplateOptions securityGroupNames(String ... securityGroupNames) {
        return this.securityGroupNames(ImmutableSet.copyOf((Object[])Preconditions.checkNotNull(securityGroupNames, "securityGroupNames")));
    }

    public NovaTemplateOptions securityGroupNames(Iterable<String> securityGroupNames) {
        for (String groupName : Preconditions.checkNotNull(securityGroupNames, "securityGroupNames")) {
            Preconditions2.checkNotEmpty(groupName, "all security groups must be non-empty");
        }
        this.securityGroupNames = Optional.of(ImmutableSet.copyOf(securityGroupNames));
        return this;
    }

    public boolean shouldAutoAssignFloatingIp() {
        return this.autoAssignFloatingIp;
    }

    public String getKeyPairName() {
        return this.keyPairName;
    }

    public boolean shouldGenerateKeyPair() {
        return this.generateKeyPair;
    }

    public Optional<Set<String>> getSecurityGroupNames() {
        return this.securityGroupNames;
    }

    public byte[] getUserData() {
        return this.userData;
    }

    @Override
    public NovaTemplateOptions blockOnPort(int port, int seconds) {
        return (NovaTemplateOptions)NovaTemplateOptions.class.cast(super.blockOnPort(port, seconds));
    }

    @Override
    public NovaTemplateOptions inboundPorts(int ... ports) {
        return (NovaTemplateOptions)NovaTemplateOptions.class.cast(super.inboundPorts(ports));
    }

    @Override
    public NovaTemplateOptions authorizePublicKey(String publicKey) {
        return (NovaTemplateOptions)NovaTemplateOptions.class.cast(super.authorizePublicKey(publicKey));
    }

    @Override
    public NovaTemplateOptions installPrivateKey(String privateKey) {
        return (NovaTemplateOptions)NovaTemplateOptions.class.cast(super.installPrivateKey(privateKey));
    }

    @Override
    public NovaTemplateOptions blockUntilRunning(boolean blockUntilRunning) {
        return (NovaTemplateOptions)NovaTemplateOptions.class.cast(super.blockUntilRunning(blockUntilRunning));
    }

    @Override
    public NovaTemplateOptions dontAuthorizePublicKey() {
        return (NovaTemplateOptions)NovaTemplateOptions.class.cast(super.dontAuthorizePublicKey());
    }

    @Override
    public NovaTemplateOptions nameTask(String name) {
        return (NovaTemplateOptions)NovaTemplateOptions.class.cast(super.nameTask(name));
    }

    @Override
    public NovaTemplateOptions runAsRoot(boolean runAsRoot) {
        return (NovaTemplateOptions)NovaTemplateOptions.class.cast(super.runAsRoot(runAsRoot));
    }

    @Override
    public NovaTemplateOptions runScript(Statement script) {
        return (NovaTemplateOptions)NovaTemplateOptions.class.cast(super.runScript(script));
    }

    @Override
    public NovaTemplateOptions overrideLoginCredentials(LoginCredentials overridingCredentials) {
        return (NovaTemplateOptions)NovaTemplateOptions.class.cast(super.overrideLoginCredentials(overridingCredentials));
    }

    @Override
    public NovaTemplateOptions overrideLoginPassword(String password) {
        return (NovaTemplateOptions)NovaTemplateOptions.class.cast(super.overrideLoginPassword(password));
    }

    @Override
    public NovaTemplateOptions overrideLoginPrivateKey(String privateKey) {
        return (NovaTemplateOptions)NovaTemplateOptions.class.cast(super.overrideLoginPrivateKey(privateKey));
    }

    @Override
    public NovaTemplateOptions overrideLoginUser(String loginUser) {
        return (NovaTemplateOptions)NovaTemplateOptions.class.cast(super.overrideLoginUser(loginUser));
    }

    @Override
    public NovaTemplateOptions overrideAuthenticateSudo(boolean authenticateSudo) {
        return (NovaTemplateOptions)NovaTemplateOptions.class.cast(super.overrideAuthenticateSudo(authenticateSudo));
    }

    @Override
    public NovaTemplateOptions userMetadata(Map<String, String> userMetadata) {
        return (NovaTemplateOptions)NovaTemplateOptions.class.cast(super.userMetadata(userMetadata));
    }

    @Override
    public NovaTemplateOptions userMetadata(String key, String value) {
        return (NovaTemplateOptions)NovaTemplateOptions.class.cast(super.userMetadata(key, value));
    }

    public NovaTemplateOptions userData(byte[] userData) {
        Preconditions.checkArgument(Preconditions.checkNotNull(userData, "userData").length <= 16384, "userData cannot be larger than 16kb");
        this.userData = userData;
        return this;
    }

    public static class Builder {
        public static NovaTemplateOptions autoAssignFloatingIp(boolean enable) {
            return new NovaTemplateOptions().autoAssignFloatingIp(enable);
        }

        public static NovaTemplateOptions generateKeyPair(boolean enable) {
            return new NovaTemplateOptions().generateKeyPair(enable);
        }

        public static NovaTemplateOptions keyPairName(String keyPairName) {
            return new NovaTemplateOptions().keyPairName(keyPairName);
        }

        public static NovaTemplateOptions securityGroupNames(String ... groupNames) {
            NovaTemplateOptions options = new NovaTemplateOptions();
            return (NovaTemplateOptions)NovaTemplateOptions.class.cast(options.securityGroupNames(groupNames));
        }

        public static NovaTemplateOptions securityGroupNames(Iterable<String> groupNames) {
            NovaTemplateOptions options = new NovaTemplateOptions();
            return (NovaTemplateOptions)NovaTemplateOptions.class.cast(options.securityGroupNames(groupNames));
        }

        public static NovaTemplateOptions inboundPorts(int ... ports) {
            NovaTemplateOptions options = new NovaTemplateOptions();
            return (NovaTemplateOptions)NovaTemplateOptions.class.cast(options.inboundPorts(ports));
        }

        public static NovaTemplateOptions blockOnPort(int port, int seconds) {
            NovaTemplateOptions options = new NovaTemplateOptions();
            return (NovaTemplateOptions)NovaTemplateOptions.class.cast(options.blockOnPort(port, seconds));
        }

        public static NovaTemplateOptions installPrivateKey(String rsaKey) {
            NovaTemplateOptions options = new NovaTemplateOptions();
            return (NovaTemplateOptions)NovaTemplateOptions.class.cast(options.installPrivateKey(rsaKey));
        }

        public static NovaTemplateOptions authorizePublicKey(String rsaKey) {
            NovaTemplateOptions options = new NovaTemplateOptions();
            return (NovaTemplateOptions)NovaTemplateOptions.class.cast(options.authorizePublicKey(rsaKey));
        }

        public static NovaTemplateOptions userMetadata(Map<String, String> userMetadata) {
            NovaTemplateOptions options = new NovaTemplateOptions();
            return (NovaTemplateOptions)NovaTemplateOptions.class.cast(options.userMetadata((Map)userMetadata));
        }

        public static NovaTemplateOptions overrideLoginUser(String user) {
            NovaTemplateOptions options = new NovaTemplateOptions();
            return options.overrideLoginUser(user);
        }

        public static NovaTemplateOptions overrideLoginPassword(String password) {
            NovaTemplateOptions options = new NovaTemplateOptions();
            return options.overrideLoginPassword(password);
        }

        public static NovaTemplateOptions overrideLoginPrivateKey(String privateKey) {
            NovaTemplateOptions options = new NovaTemplateOptions();
            return options.overrideLoginPrivateKey(privateKey);
        }

        public static NovaTemplateOptions overrideAuthenticateSudo(boolean authenticateSudo) {
            NovaTemplateOptions options = new NovaTemplateOptions();
            return options.overrideAuthenticateSudo(authenticateSudo);
        }

        public static NovaTemplateOptions overrideLoginCredentials(LoginCredentials credentials) {
            NovaTemplateOptions options = new NovaTemplateOptions();
            return options.overrideLoginCredentials(credentials);
        }

        public static NovaTemplateOptions blockUntilRunning(boolean blockUntilRunning) {
            NovaTemplateOptions options = new NovaTemplateOptions();
            return options.blockUntilRunning(blockUntilRunning);
        }

        public static NovaTemplateOptions userData(byte[] userData) {
            NovaTemplateOptions options = new NovaTemplateOptions();
            return (NovaTemplateOptions)NovaTemplateOptions.class.cast(options.userData(userData));
        }
    }
}

