/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.nova.domain;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.beans.ConstructorProperties;
import java.net.URI;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jclouds.javax.annotation.Nullable;
import org.jclouds.openstack.nova.domain.Addresses;
import org.jclouds.openstack.nova.domain.Flavor;
import org.jclouds.openstack.nova.domain.Image;
import org.jclouds.openstack.nova.domain.Resource;
import org.jclouds.openstack.nova.domain.SecurityGroup;
import org.jclouds.openstack.nova.domain.ServerStatus;

public class Server
extends Resource {
    private final String name;
    private final Map<String, String> metadata;
    private final Addresses addresses;
    private final String accessIPv4;
    private final String accessIPv6;
    private final String adminPass;
    private final String flavorRef;
    private final String hostId;
    private final String imageRef;
    private final String affinityId;
    private final String uuid;
    private final Flavor flavor;
    private final Image image;
    private final String keyName;
    private final Set<SecurityGroup> securityGroups;
    private final Date created;
    private final Date updated;
    private final Integer progress;
    private final ServerStatus status;

    public static Builder<?> builder() {
        return new ConcreteBuilder();
    }

    public Builder<?> toBuilder() {
        return new ConcreteBuilder().fromServer(this);
    }

    @ConstructorProperties(value={"id", "links", "orderedSelfReferences", "name", "metadata", "addresses", "accessIPv4", "accessIPv6", "adminPass", "flavorRef", "hostId", "imageRef", "affinityId", "uuid", "flavor", "image", "key_name", "security_groups", "created", "updated", "progress", "status"})
    protected Server(int id, List<Map<String, String>> links, Map<Resource.LinkType, URI> orderedSelfReferences, String name, @Nullable Map<String, String> metadata, @Nullable Addresses addresses, @Nullable String accessIPv4, @Nullable String accessIPv6, @Nullable String adminPass, @Nullable String flavorRef, @Nullable String hostId, @Nullable String imageRef, @Nullable String affinityId, @Nullable String uuid, @Nullable Flavor flavor, @Nullable Image image, @Nullable String keyName, @Nullable Set<SecurityGroup> securityGroups, @Nullable Date created, @Nullable Date updated, @Nullable Integer progress, @Nullable ServerStatus status) {
        super(id, links, orderedSelfReferences);
        this.name = Preconditions.checkNotNull(name, "name");
        this.metadata = metadata == null ? ImmutableMap.of() : ImmutableMap.copyOf(metadata);
        this.addresses = addresses;
        this.accessIPv4 = accessIPv4;
        this.accessIPv6 = accessIPv6;
        this.adminPass = adminPass;
        this.flavorRef = flavorRef;
        this.hostId = hostId;
        this.imageRef = imageRef;
        this.affinityId = affinityId;
        this.uuid = uuid;
        this.flavor = flavor;
        this.image = image;
        this.keyName = keyName;
        this.securityGroups = securityGroups == null ? ImmutableSet.of() : ImmutableSet.copyOf(securityGroups);
        this.created = created;
        this.updated = updated;
        this.progress = progress;
        this.status = status == null ? ServerStatus.UNKNOWN : status;
    }

    public String getName() {
        return this.name;
    }

    public Map<String, String> getMetadata() {
        return this.metadata;
    }

    @Nullable
    public Addresses getAddresses() {
        return this.addresses;
    }

    @Nullable
    public String getAccessIPv4() {
        return this.accessIPv4;
    }

    @Nullable
    public String getAccessIPv6() {
        return this.accessIPv6;
    }

    @Nullable
    public String getAdminPass() {
        return this.adminPass;
    }

    @Nullable
    public String getFlavorRef() {
        return this.flavorRef;
    }

    @Nullable
    public String getHostId() {
        return this.hostId;
    }

    @Nullable
    public String getImageRef() {
        return this.imageRef;
    }

    @Nullable
    public String getAffinityId() {
        return this.affinityId;
    }

    @Nullable
    public String getUuid() {
        return this.uuid;
    }

    @Nullable
    public Flavor getFlavor() {
        return this.flavor;
    }

    public Image getImage() {
        return this.image;
    }

    @Nullable
    public String getKeyName() {
        return this.keyName;
    }

    public Set<SecurityGroup> getSecurityGroups() {
        return this.securityGroups;
    }

    @Nullable
    public Date getCreated() {
        return this.created;
    }

    @Nullable
    public Date getUpdated() {
        return this.updated;
    }

    @Nullable
    public Integer getProgress() {
        return this.progress;
    }

    public ServerStatus getStatus() {
        return this.status;
    }

    @Override
    public int hashCode() {
        return Objects.hashCode(super.hashCode(), this.name, this.metadata, this.addresses, this.accessIPv4, this.accessIPv6, this.adminPass, this.flavorRef, this.hostId, this.imageRef, this.affinityId, this.uuid, this.flavor, this.image, this.keyName, this.securityGroups, this.created, this.updated);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        Server that = (Server)Server.class.cast(obj);
        return super.equals(that) && Objects.equal(this.name, that.name) && Objects.equal(this.metadata, that.metadata) && Objects.equal(this.addresses, that.addresses) && Objects.equal(this.accessIPv4, that.accessIPv4) && Objects.equal(this.accessIPv6, that.accessIPv6) && Objects.equal(this.adminPass, that.adminPass) && Objects.equal(this.flavorRef, that.flavorRef) && Objects.equal(this.hostId, that.hostId) && Objects.equal(this.imageRef, that.imageRef) && Objects.equal(this.affinityId, that.affinityId) && Objects.equal(this.uuid, that.uuid) && Objects.equal(this.flavor, that.flavor) && Objects.equal(this.image, that.image) && Objects.equal(this.keyName, that.keyName) && Objects.equal(this.securityGroups, that.securityGroups) && Objects.equal(this.created, that.created) && Objects.equal(this.updated, that.updated);
    }

    @Override
    protected Objects.ToStringHelper string() {
        return super.string().add("name", this.name).add("metadata", this.metadata).add("addresses", this.addresses).add("accessIPv4", this.accessIPv4).add("accessIPv6", this.accessIPv6).add("adminPass", this.adminPass).add("flavorRef", this.flavorRef).add("hostId", this.hostId).add("imageRef", this.imageRef).add("affinityId", this.affinityId).add("uuid", this.uuid).add("flavor", this.flavor).add("image", this.image).add("keyName", this.keyName).add("securityGroups", this.securityGroups).add("created", this.created).add("updated", this.updated).add("progress", this.progress).add("status", (Object)this.status);
    }

    private static class ConcreteBuilder
    extends Builder<ConcreteBuilder> {
        private ConcreteBuilder() {
        }

        @Override
        protected ConcreteBuilder self() {
            return this;
        }
    }

    public static abstract class Builder<T extends Builder<T>>
    extends Resource.Builder<T> {
        protected String name;
        protected Map<String, String> metadata = ImmutableMap.of();
        protected Addresses addresses;
        protected String accessIPv4;
        protected String accessIPv6;
        protected String adminPass;
        protected String flavorRef;
        protected String hostId;
        protected String imageRef;
        protected String affinityId;
        protected String uuid;
        protected Flavor flavor;
        protected Image image;
        protected String keyName;
        protected Set<SecurityGroup> securityGroups = ImmutableSet.of();
        protected Date created;
        protected Date updated;
        protected Integer progress;
        protected ServerStatus status;

        public T name(String name) {
            this.name = name;
            return (T)((Builder)this.self());
        }

        public T metadata(Map<String, String> metadata) {
            this.metadata = ImmutableMap.copyOf(Preconditions.checkNotNull(metadata, "metadata"));
            return (T)((Builder)this.self());
        }

        public T addresses(Addresses addresses) {
            this.addresses = addresses;
            return (T)((Builder)this.self());
        }

        public T accessIPv4(String accessIPv4) {
            this.accessIPv4 = accessIPv4;
            return (T)((Builder)this.self());
        }

        public T accessIPv6(String accessIPv6) {
            this.accessIPv6 = accessIPv6;
            return (T)((Builder)this.self());
        }

        public T adminPass(String adminPass) {
            this.adminPass = adminPass;
            return (T)((Builder)this.self());
        }

        public T flavorRef(String flavorRef) {
            this.flavorRef = flavorRef;
            return (T)((Builder)this.self());
        }

        public T hostId(String hostId) {
            this.hostId = hostId;
            return (T)((Builder)this.self());
        }

        public T imageRef(String imageRef) {
            this.imageRef = imageRef;
            return (T)((Builder)this.self());
        }

        public T affinityId(String affinityId) {
            this.affinityId = affinityId;
            return (T)((Builder)this.self());
        }

        public T uuid(String uuid) {
            this.uuid = uuid;
            return (T)((Builder)this.self());
        }

        public T flavor(Flavor flavor) {
            this.flavor = flavor;
            return (T)((Builder)this.self());
        }

        public T image(Image image) {
            this.image = image;
            return (T)((Builder)this.self());
        }

        public T keyName(String keyName) {
            this.keyName = keyName;
            return (T)((Builder)this.self());
        }

        public T securityGroups(Set<SecurityGroup> securityGroups) {
            this.securityGroups = ImmutableSet.copyOf((Collection)Preconditions.checkNotNull(securityGroups, "securityGroups"));
            return (T)((Builder)this.self());
        }

        public T securityGroups(SecurityGroup ... in) {
            return this.securityGroups(ImmutableSet.copyOf(in));
        }

        public T created(Date created) {
            this.created = created;
            return (T)((Builder)this.self());
        }

        public T updated(Date updated) {
            this.updated = updated;
            return (T)((Builder)this.self());
        }

        public T progress(Integer progress) {
            this.progress = progress;
            return (T)((Builder)this.self());
        }

        public T status(ServerStatus status) {
            this.status = status;
            return (T)((Builder)this.self());
        }

        public Server build() {
            return new Server(this.id, this.links, this.orderedSelfReferences, this.name, this.metadata, this.addresses, this.accessIPv4, this.accessIPv6, this.adminPass, this.flavorRef, this.hostId, this.imageRef, this.affinityId, this.uuid, this.flavor, this.image, this.keyName, this.securityGroups, this.created, this.updated, this.progress, this.status);
        }

        public T fromServer(Server in) {
            return ((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)super.fromResource(in)).id(in.getId())).name(in.getName())).metadata(in.getMetadata())).addresses(in.getAddresses())).accessIPv4(in.getAccessIPv4())).accessIPv6(in.getAccessIPv6())).adminPass(in.getAdminPass())).flavorRef(in.getFlavorRef())).hostId(in.getHostId())).imageRef(in.getImageRef())).affinityId(in.getAffinityId())).uuid(in.getUuid())).flavor(in.getFlavor())).image(in.getImage())).keyName(in.getKeyName())).securityGroups(in.getSecurityGroups())).created(in.getCreated())).updated(in.getUpdated())).progress(in.getProgress())).status(in.getStatus());
        }
    }
}

