/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.nova.domain;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import java.beans.ConstructorProperties;
import javax.ws.rs.HttpMethod;
import org.jclouds.openstack.nova.domain.RateLimitUnit;

public class RateLimit {
    private final String uri;
    private final String regex;
    private final int remaining;
    private final long resetTime;
    private final RateLimitUnit unit;
    private final int value;
    private final HttpMethod verb;

    public static Builder<?> builder() {
        return new ConcreteBuilder();
    }

    public Builder<?> toBuilder() {
        return new ConcreteBuilder().fromRateLimit(this);
    }

    @ConstructorProperties(value={"uri", "regex", "remaining", "resetTime", "unit", "value", "verb"})
    protected RateLimit(String uri, String regex, int remaining, long resetTime, RateLimitUnit unit, int value, HttpMethod verb) {
        this.uri = Preconditions.checkNotNull(uri, "uri");
        this.regex = Preconditions.checkNotNull(regex, "regex");
        this.remaining = remaining;
        this.resetTime = resetTime;
        this.unit = Preconditions.checkNotNull(unit, "unit");
        this.value = value;
        this.verb = Preconditions.checkNotNull(verb, "verb");
    }

    public String getUri() {
        return this.uri;
    }

    public String getRegex() {
        return this.regex;
    }

    public int getRemaining() {
        return this.remaining;
    }

    public long getResetTime() {
        return this.resetTime;
    }

    public RateLimitUnit getUnit() {
        return this.unit;
    }

    public int getValue() {
        return this.value;
    }

    public HttpMethod getVerb() {
        return this.verb;
    }

    public int hashCode() {
        return Objects.hashCode(new Object[]{this.uri, this.regex, this.remaining, this.resetTime, this.unit, this.value, this.verb});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        RateLimit that = (RateLimit)RateLimit.class.cast(obj);
        return Objects.equal(this.uri, that.uri) && Objects.equal(this.regex, that.regex) && Objects.equal(this.remaining, that.remaining) && Objects.equal(this.resetTime, that.resetTime) && Objects.equal((Object)this.unit, (Object)that.unit) && Objects.equal(this.value, that.value) && Objects.equal(this.verb, that.verb);
    }

    protected Objects.ToStringHelper string() {
        return Objects.toStringHelper(this).add("uri", this.uri).add("regex", this.regex).add("remaining", this.remaining).add("resetTime", this.resetTime).add("unit", (Object)this.unit).add("value", this.value).add("verb", this.verb);
    }

    public String toString() {
        return this.string().toString();
    }

    private static class ConcreteBuilder
    extends Builder<ConcreteBuilder> {
        private ConcreteBuilder() {
        }

        @Override
        protected ConcreteBuilder self() {
            return this;
        }
    }

    public static abstract class Builder<T extends Builder<T>> {
        protected String uri;
        protected String regex;
        protected int remaining;
        protected long resetTime;
        protected RateLimitUnit unit;
        protected int value;
        protected HttpMethod verb;

        protected abstract T self();

        public T uri(String uri) {
            this.uri = uri;
            return this.self();
        }

        public T regex(String regex) {
            this.regex = regex;
            return this.self();
        }

        public T remaining(int remaining) {
            this.remaining = remaining;
            return this.self();
        }

        public T resetTime(long resetTime) {
            this.resetTime = resetTime;
            return this.self();
        }

        public T unit(RateLimitUnit unit) {
            this.unit = unit;
            return this.self();
        }

        public T value(int value) {
            this.value = value;
            return this.self();
        }

        public T verb(HttpMethod verb) {
            this.verb = verb;
            return this.self();
        }

        public RateLimit build() {
            return new RateLimit(this.uri, this.regex, this.remaining, this.resetTime, this.unit, this.value, this.verb);
        }

        public T fromRateLimit(RateLimit in) {
            return ((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)this.uri(in.getUri())).regex(in.getRegex())).remaining(in.getRemaining())).resetTime(in.getResetTime())).unit(in.getUnit())).value(in.getValue())).verb(in.getVerb());
        }
    }
}

