/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.nova.domain;

import com.google.common.base.Function;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import java.beans.ConstructorProperties;
import org.jclouds.javax.annotation.Nullable;

public class Address {
    private final String address;
    private final int version;

    public static Builder<?> builder() {
        return new ConcreteBuilder();
    }

    public Builder<?> toBuilder() {
        return new ConcreteBuilder().fromAddress(this);
    }

    public static Function<Address, String> newAddress2StringFunction() {
        return new Function<Address, String>(){

            @Override
            public String apply(@Nullable Address input) {
                return input.getAddress();
            }
        };
    }

    public static Address valueOf(String address) {
        return new Address(address, address.startsWith("::") ? 6 : 4);
    }

    public static Function<String, Address> newString2AddressFunction() {
        return new Function<String, Address>(){

            @Override
            public Address apply(@Nullable String input) {
                return Address.valueOf(input);
            }
        };
    }

    @ConstructorProperties(value={"addr", "version"})
    protected Address(String address, int version) {
        this.address = Preconditions.checkNotNull(address, "address");
        this.version = version;
    }

    public String getAddress() {
        return this.address;
    }

    public int getVersion() {
        return this.version;
    }

    public int hashCode() {
        return Objects.hashCode(this.address, this.version);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        Address that = (Address)Address.class.cast(obj);
        return Objects.equal(this.address, that.address) && Objects.equal(this.version, that.version);
    }

    protected Objects.ToStringHelper string() {
        return Objects.toStringHelper(this).add("address", this.address).add("version", this.version);
    }

    public String toString() {
        return this.string().toString();
    }

    private static class ConcreteBuilder
    extends Builder<ConcreteBuilder> {
        private ConcreteBuilder() {
        }

        @Override
        protected ConcreteBuilder self() {
            return this;
        }
    }

    public static abstract class Builder<T extends Builder<T>> {
        protected String address;
        protected int version;

        protected abstract T self();

        public T address(String address) {
            this.address = address;
            return this.self();
        }

        public T version(int version) {
            this.version = version;
            return this.self();
        }

        public Address build() {
            return new Address(this.address, this.version);
        }

        public T fromAddress(Address in) {
            return ((Builder)this.address(in.getAddress())).version(in.getVersion());
        }
    }
}

