/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.location.predicates.fromconfig;

import com.google.common.base.Preconditions;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.jclouds.location.predicates.RegionIdFilter;
import org.jclouds.location.suppliers.fromconfig.RegionIdsFromConfiguration;

@Singleton
public class AnyOrConfiguredRegionId
implements RegionIdFilter {
    private RegionIdsFromConfiguration idsInConfigSupplier;

    @Inject
    protected AnyOrConfiguredRegionId(RegionIdsFromConfiguration idsInConfigSupplier) {
        this.idsInConfigSupplier = Preconditions.checkNotNull(idsInConfigSupplier, "idsInConfigSupplier");
    }

    @Override
    public boolean apply(String input) {
        Object idsInConfig = this.idsInConfigSupplier.get();
        if (idsInConfig.size() == 0) {
            return true;
        }
        return idsInConfig.contains(input);
    }

    public String toString() {
        return "anyOrConfiguredRegionId(" + this.idsInConfigSupplier + ")";
    }
}

