/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.hpcloud.objectstorage.domain;

import com.google.common.base.Objects;
import com.google.common.base.Strings;
import java.beans.ConstructorProperties;
import java.net.URI;
import org.jclouds.javax.annotation.Nullable;

public class CDNContainer
implements Comparable<CDNContainer> {
    private final String name;
    private final boolean cdnEnabled;
    private final boolean logRetention;
    private final long ttl;
    private final URI CDNUri;
    private final URI CDNSslUri;
    private final String referrerAcl;
    private final String useragentAcl;

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return CDNContainer.builder().fromCDNContainer(this);
    }

    @ConstructorProperties(value={"name", "cdnEnabled", "ttl", "cdnUri", "cdnSslUri", "referrerAcl", "useragentAcl", "logRetention"})
    protected CDNContainer(@Nullable String name, boolean cdnEnabled, long ttl, @Nullable URI CDNUri, @Nullable URI CDNSslUri, @Nullable String referrerAcl, @Nullable String useragentAcl, boolean logRetention) {
        this.name = Strings.emptyToNull(name);
        this.cdnEnabled = cdnEnabled;
        this.ttl = ttl;
        this.CDNUri = CDNUri;
        this.CDNSslUri = CDNSslUri;
        this.referrerAcl = Strings.emptyToNull(referrerAcl);
        this.useragentAcl = Strings.emptyToNull(useragentAcl);
        this.logRetention = logRetention;
    }

    @Nullable
    public String getName() {
        return this.name;
    }

    public boolean isCDNEnabled() {
        return this.cdnEnabled;
    }

    public long getTTL() {
        return this.ttl;
    }

    @Nullable
    public URI getCDNUri() {
        return this.CDNUri;
    }

    @Nullable
    public URI getCDNSslUri() {
        return this.CDNSslUri;
    }

    @Nullable
    public String getReferrerAcl() {
        return this.referrerAcl;
    }

    @Nullable
    public String getUseragentAcl() {
        return this.useragentAcl;
    }

    public boolean isLogRetention() {
        return this.logRetention;
    }

    public int hashCode() {
        return Objects.hashCode(this.name, this.CDNUri);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        CDNContainer that = (CDNContainer)CDNContainer.class.cast(obj);
        return Objects.equal(this.name, that.name) && Objects.equal(this.CDNUri, that.CDNUri);
    }

    protected Objects.ToStringHelper string() {
        return Objects.toStringHelper(this).omitNullValues().add("name", this.name).add("cdnEnabled", this.cdnEnabled).add("ttl", this.ttl).add("CDNUri", this.CDNUri).add("CDNSslUri", this.CDNSslUri).add("referrerAcl", this.referrerAcl).add("useragentAcl", this.useragentAcl).add("logRetention", this.logRetention);
    }

    public String toString() {
        return this.string().toString();
    }

    @Override
    public int compareTo(CDNContainer o) {
        if (this.getName() == null) {
            return -1;
        }
        return this == o ? 0 : this.getName().compareTo(o.getName());
    }

    public static class Builder {
        protected String name;
        protected boolean cdnEnabled;
        protected boolean logRetention;
        protected long ttl;
        protected URI cdnUri;
        protected URI cdnSslUri;
        protected String referrerAcl;
        protected String useragentAcl;

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder CDNEnabled(boolean cdnEnabled) {
            this.cdnEnabled = cdnEnabled;
            return this;
        }

        public Builder ttl(long ttl) {
            this.ttl = ttl;
            return this;
        }

        public Builder CDNUri(URI cdnUri) {
            this.cdnUri = cdnUri;
            return this;
        }

        public Builder CDNSslUri(URI cdnSslUri) {
            this.cdnSslUri = cdnSslUri;
            return this;
        }

        public Builder referrerAcl(String referrerAcl) {
            this.referrerAcl = referrerAcl;
            return this;
        }

        public Builder useragentAcl(String useragentAcl) {
            this.useragentAcl = useragentAcl;
            return this;
        }

        public Builder logRetention(boolean logRetention) {
            this.logRetention = logRetention;
            return this;
        }

        public CDNContainer build() {
            return new CDNContainer(this.name, this.cdnEnabled, this.ttl, this.cdnUri, this.cdnSslUri, this.referrerAcl, this.useragentAcl, this.logRetention);
        }

        public Builder fromCDNContainer(CDNContainer in) {
            return this.name(in.getName()).CDNEnabled(in.isCDNEnabled()).ttl(in.getTTL()).CDNUri(in.getCDNUri()).CDNSslUri(in.getCDNSslUri()).referrerAcl(in.getReferrerAcl()).useragentAcl(in.getUseragentAcl()).logRetention(in.isLogRetention());
        }
    }
}

