/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.gogrid.services;

import com.google.common.util.concurrent.ListenableFuture;
import java.util.Map;
import java.util.Set;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.QueryParam;
import org.jclouds.domain.Credentials;
import org.jclouds.gogrid.domain.Option;
import org.jclouds.gogrid.domain.PowerCommand;
import org.jclouds.gogrid.domain.Server;
import org.jclouds.gogrid.filters.SharedKeyLiteAuthentication;
import org.jclouds.gogrid.functions.ParseCredentialsFromJsonResponse;
import org.jclouds.gogrid.functions.ParseOptionsFromJsonResponse;
import org.jclouds.gogrid.functions.ParseServerNameToCredentialsMapFromJsonResponse;
import org.jclouds.gogrid.options.AddServerOptions;
import org.jclouds.gogrid.options.GetServerListOptions;
import org.jclouds.rest.annotations.ExceptionParser;
import org.jclouds.rest.annotations.OnlyElement;
import org.jclouds.rest.annotations.QueryParams;
import org.jclouds.rest.annotations.RequestFilters;
import org.jclouds.rest.annotations.ResponseParser;
import org.jclouds.rest.annotations.SelectJson;
import org.jclouds.rest.functions.ReturnEmptySetOnNotFoundOr404;
import org.jclouds.rest.functions.ReturnNullOnNotFoundOr404;

@RequestFilters(value={SharedKeyLiteAuthentication.class})
@QueryParams(keys={"v"}, values={"1.6"})
public interface GridServerAsyncClient {
    @GET
    @SelectJson(value={"list"})
    @ExceptionParser(value=ReturnEmptySetOnNotFoundOr404.class)
    @Path(value="/grid/server/list")
    public ListenableFuture<Set<Server>> getServerList(GetServerListOptions ... var1);

    @GET
    @SelectJson(value={"list"})
    @ExceptionParser(value=ReturnEmptySetOnNotFoundOr404.class)
    @Path(value="/grid/server/get")
    public ListenableFuture<Set<Server>> getServersByName(String ... var1);

    @GET
    @SelectJson(value={"list"})
    @ExceptionParser(value=ReturnEmptySetOnNotFoundOr404.class)
    @Path(value="/grid/server/get")
    public ListenableFuture<Set<Server>> getServersById(long ... var1);

    @GET
    @ResponseParser(value=ParseServerNameToCredentialsMapFromJsonResponse.class)
    @Path(value="/support/password/list")
    public ListenableFuture<Map<String, Credentials>> getServerCredentialsList();

    @GET
    @ResponseParser(value=ParseCredentialsFromJsonResponse.class)
    @Path(value="/support/grid/password/get")
    public ListenableFuture<Credentials> getServerCredentials(@QueryParam(value="id") long var1);

    @GET
    @SelectJson(value={"list"})
    @OnlyElement
    @Path(value="/grid/server/add")
    public ListenableFuture<Server> addServer(@QueryParam(value="name") String var1, @QueryParam(value="image") String var2, @QueryParam(value="server.ram") String var3, @QueryParam(value="ip") String var4, AddServerOptions ... var5);

    @GET
    @SelectJson(value={"list"})
    @OnlyElement
    @Path(value="/grid/server/power")
    public ListenableFuture<Server> power(@QueryParam(value="server") String var1, @QueryParam(value="power") PowerCommand var2);

    @GET
    @SelectJson(value={"list"})
    @OnlyElement
    @Path(value="/grid/server/delete")
    @ExceptionParser(value=ReturnNullOnNotFoundOr404.class)
    public ListenableFuture<Server> deleteById(@QueryParam(value="id") long var1);

    @GET
    @SelectJson(value={"list"})
    @OnlyElement
    @Path(value="/grid/server/delete")
    @ExceptionParser(value=ReturnNullOnNotFoundOr404.class)
    public ListenableFuture<Server> deleteByName(@QueryParam(value="name") String var1);

    @GET
    @ResponseParser(value=ParseOptionsFromJsonResponse.class)
    @Path(value="/common/lookup/list")
    @QueryParams(keys={"lookup"}, values={"server.ram"})
    public ListenableFuture<Set<Option>> getRamSizes();

    @GET
    @ResponseParser(value=ParseOptionsFromJsonResponse.class)
    @Path(value="/common/lookup/list")
    @QueryParams(keys={"lookup"}, values={"server.type"})
    public ListenableFuture<Set<Option>> getTypes();

    @GET
    @ResponseParser(value=ParseOptionsFromJsonResponse.class)
    @Path(value="/common/lookup/list")
    @QueryParams(keys={"lookup"}, values={"server.datacenter"})
    public ListenableFuture<Set<Option>> getDatacenters();

    @GET
    @SelectJson(value={"list"})
    @OnlyElement
    @Path(value="/grid/server/edit")
    public ListenableFuture<Server> editServerDescription(@QueryParam(value="id") long var1, @QueryParam(value="description") String var3);

    @GET
    @SelectJson(value={"list"})
    @OnlyElement
    @Path(value="/grid/server/edit")
    public ListenableFuture<Server> editServerRam(@QueryParam(value="id") long var1, @QueryParam(value="server.ram") String var3);

    @GET
    @SelectJson(value={"list"})
    @OnlyElement
    @Path(value="/grid/server/edit")
    public ListenableFuture<Server> editServerType(@QueryParam(value="id") long var1, @QueryParam(value="server.type") String var3);
}

