/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.gogrid.filters;

import com.google.common.base.Supplier;
import com.google.common.collect.ImmutableMap;
import javax.annotation.Resource;
import javax.inject.Inject;
import javax.inject.Named;
import org.jclouds.crypto.CryptoStreams;
import org.jclouds.date.TimeStamp;
import org.jclouds.domain.Credentials;
import org.jclouds.http.HttpRequest;
import org.jclouds.http.HttpRequestFilter;
import org.jclouds.http.HttpUtils;
import org.jclouds.io.InputSuppliers;
import org.jclouds.location.Provider;
import org.jclouds.logging.Logger;

public class SharedKeyLiteAuthentication
implements HttpRequestFilter {
    private final Supplier<Credentials> creds;
    private final Long timeStamp;
    private final HttpUtils utils;
    @Resource
    @Named(value="jclouds.signature")
    Logger signatureLog = Logger.NULL;

    @Inject
    public SharedKeyLiteAuthentication(@Provider Supplier<Credentials> creds, @TimeStamp Long timeStamp, HttpUtils utils) {
        this.creds = creds;
        this.timeStamp = timeStamp;
        this.utils = utils;
    }

    @Override
    public HttpRequest filter(HttpRequest request) {
        String toSign = this.createStringToSign();
        String signatureMd5 = this.getMd5For(toSign);
        request = ((HttpRequest.Builder)((HttpRequest.Builder)request.toBuilder()).replaceQueryParams(ImmutableMap.of("sig", signatureMd5, "api_key", this.creds.get().identity))).build();
        this.utils.logRequest(this.signatureLog, request, "<<");
        return request;
    }

    private String createStringToSign() {
        return String.format("%s%s%s", this.creds.get().identity, this.creds.get().credential, this.timeStamp);
    }

    private String getMd5For(String stringToHash) {
        try {
            return CryptoStreams.md5Hex(InputSuppliers.of(stringToHash));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

