/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.gogrid.binders;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMultimap;
import java.util.List;
import org.jclouds.gogrid.domain.IpPortPair;
import org.jclouds.http.HttpRequest;
import org.jclouds.rest.Binder;

public class BindRealIpPortPairsToQueryParams
implements Binder {
    @Override
    public <R extends HttpRequest> R bindToRequest(R request, Object input) {
        Preconditions.checkArgument(Preconditions.checkNotNull(input, "input is null") instanceof List, "this binder is only valid for a List argument");
        List ipPortPairs = (List)input;
        ImmutableMultimap.Builder<String, String> builder = ImmutableMultimap.builder();
        int i = 0;
        for (IpPortPair ipPortPair : ipPortPairs) {
            Preconditions.checkNotNull(ipPortPair.getIp(), "There must be an IP address defined");
            Preconditions.checkNotNull(ipPortPair.getIp().getIp(), "There must be an IP address defined in Ip object");
            Preconditions.checkState(ipPortPair.getPort() > 0, "The port number must be a positive integer");
            builder.put("realiplist." + i + ".ip", ipPortPair.getIp().getIp());
            builder.put("realiplist." + i + ".port", String.valueOf(ipPortPair.getPort()));
            ++i;
        }
        return (R)((HttpRequest.Builder)((HttpRequest.Builder)request.toBuilder()).replaceQueryParams(builder.build())).build();
    }
}

