/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.gogrid.binders;

import com.google.common.base.Functions;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.primitives.Longs;
import javax.inject.Singleton;
import org.jclouds.http.HttpRequest;
import org.jclouds.rest.Binder;

@Singleton
public class BindIdsToQueryParams
implements Binder {
    @Override
    public <R extends HttpRequest> R bindToRequest(R request, Object input) {
        if (Preconditions.checkNotNull(input, "input is null") instanceof Long[]) {
            Long[] names = (Long[])input;
            return (R)((HttpRequest.Builder)((HttpRequest.Builder)request.toBuilder()).replaceQueryParam("id", Iterables.transform(ImmutableList.copyOf(names), Functions.toStringFunction()))).build();
        }
        if (input instanceof long[]) {
            long[] names = (long[])input;
            return (R)((HttpRequest.Builder)((HttpRequest.Builder)request.toBuilder()).replaceQueryParam("id", Iterables.transform(Longs.asList(names), Functions.toStringFunction()))).build();
        }
        throw new IllegalArgumentException("this binder is only valid for Long[] arguments: " + input.getClass());
    }
}

