/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.elasticstack.functions;

import com.google.common.base.Function;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.jclouds.elasticstack.domain.DriveInfo;
import org.jclouds.elasticstack.functions.ListOfKeyValuesDelimitedByBlankLinesToListOfMaps;
import org.jclouds.elasticstack.functions.MapToDriveInfo;
import org.jclouds.http.HttpResponse;
import org.jclouds.http.functions.ReturnStringIf2xx;

@Singleton
public class ListOfKeyValuesDelimitedByBlankLinesToDriveInfoSet
implements Function<HttpResponse, Set<DriveInfo>> {
    private final ReturnStringIf2xx returnStringIf200;
    private final ListOfKeyValuesDelimitedByBlankLinesToListOfMaps mapConverter;
    private final MapToDriveInfo mapToDrive;

    @Inject
    ListOfKeyValuesDelimitedByBlankLinesToDriveInfoSet(ReturnStringIf2xx returnStringIf200, ListOfKeyValuesDelimitedByBlankLinesToListOfMaps mapConverter, MapToDriveInfo mapToDrive) {
        this.returnStringIf200 = returnStringIf200;
        this.mapConverter = mapConverter;
        this.mapToDrive = mapToDrive;
    }

    @Override
    public Set<DriveInfo> apply(HttpResponse response) {
        String text = this.returnStringIf200.apply(response);
        if (text == null || text.trim().equals("")) {
            return ImmutableSet.of();
        }
        return ImmutableSet.copyOf(Iterables.transform(this.mapConverter.apply(text), this.mapToDrive));
    }
}

