/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.ec2.predicates;

import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.inject.Inject;
import javax.annotation.Resource;
import javax.inject.Singleton;
import org.jclouds.ec2.domain.Snapshot;
import org.jclouds.ec2.options.DescribeSnapshotsOptions;
import org.jclouds.ec2.services.ElasticBlockStoreClient;
import org.jclouds.logging.Logger;

@Singleton
public class SnapshotCompleted
implements Predicate<Snapshot> {
    private final ElasticBlockStoreClient client;
    @Resource
    protected Logger logger = Logger.NULL;

    @Inject
    public SnapshotCompleted(ElasticBlockStoreClient client) {
        this.client = client;
    }

    @Override
    public boolean apply(Snapshot snapshot) {
        this.logger.trace("looking for status on snapshot %s", snapshot.getId());
        snapshot = Iterables.getOnlyElement(this.client.describeSnapshotsInRegion(snapshot.getRegion(), DescribeSnapshotsOptions.Builder.snapshotIds(snapshot.getId())));
        this.logger.trace("%s: looking for status %s: currently: %s; progress %d/100", new Object[]{snapshot, Snapshot.Status.COMPLETED, snapshot.getStatus(), snapshot.getProgress()});
        return snapshot.getStatus() == Snapshot.Status.COMPLETED;
    }
}

