/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.ec2.predicates;

import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.inject.Inject;
import java.util.NoSuchElementException;
import javax.annotation.Resource;
import javax.inject.Singleton;
import org.jclouds.ec2.EC2Client;
import org.jclouds.ec2.domain.InstanceState;
import org.jclouds.ec2.domain.RunningInstance;
import org.jclouds.logging.Logger;

@Singleton
public class InstanceStateTerminated
implements Predicate<RunningInstance> {
    private final EC2Client client;
    @Resource
    protected Logger logger = Logger.NULL;

    @Inject
    public InstanceStateTerminated(EC2Client client) {
        this.client = client;
    }

    @Override
    public boolean apply(RunningInstance instance) {
        this.logger.trace("looking for state on instance %s", instance);
        try {
            instance = this.refresh(instance);
        }
        catch (NoSuchElementException e) {
            return true;
        }
        this.logger.trace("%s: looking for instance state %s: currently: %s", new Object[]{instance.getId(), InstanceState.TERMINATED, instance.getInstanceState()});
        return instance.getInstanceState() == InstanceState.TERMINATED;
    }

    private RunningInstance refresh(RunningInstance instance) {
        return (RunningInstance)Iterables.getOnlyElement(Iterables.getOnlyElement(this.client.getInstanceServices().describeInstancesInRegion(instance.getRegion(), instance.getId())));
    }
}

