/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.ec2.features;

import com.google.common.collect.FluentIterable;
import com.google.common.collect.Multimap;
import com.google.common.util.concurrent.ListenableFuture;
import java.util.Map;
import javax.inject.Named;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import org.jclouds.aws.filters.FormSigner;
import org.jclouds.ec2.binders.BindFiltersToIndexedFormParams;
import org.jclouds.ec2.binders.BindResourceIdsToIndexedFormParams;
import org.jclouds.ec2.binders.BindTagKeysToIndexedFormParams;
import org.jclouds.ec2.binders.BindTagsToIndexedFormParams;
import org.jclouds.ec2.domain.Tag;
import org.jclouds.ec2.xml.DescribeTagsResponseHandler;
import org.jclouds.rest.annotations.BinderParam;
import org.jclouds.rest.annotations.ExceptionParser;
import org.jclouds.rest.annotations.FormParams;
import org.jclouds.rest.annotations.RequestFilters;
import org.jclouds.rest.annotations.SinceApiVersion;
import org.jclouds.rest.annotations.VirtualHost;
import org.jclouds.rest.annotations.XMLResponseParser;
import org.jclouds.rest.functions.ReturnEmptyFluentIterableOnNotFoundOr404;

@SinceApiVersion(value="2010-08-31")
@RequestFilters(value={FormSigner.class})
@VirtualHost
public interface TagAsyncApi {
    @Named(value="ec2:CreateTags")
    @POST
    @Path(value="/")
    @FormParams(keys={"Action"}, values={"CreateTags"})
    public ListenableFuture<Void> applyToResources(@BinderParam(value=BindTagsToIndexedFormParams.class) Iterable<String> var1, @BinderParam(value=BindResourceIdsToIndexedFormParams.class) Iterable<String> var2);

    @Named(value="ec2:CreateTags")
    @POST
    @Path(value="/")
    @FormParams(keys={"Action"}, values={"CreateTags"})
    public ListenableFuture<Void> applyToResources(@BinderParam(value=BindTagsToIndexedFormParams.class) Map<String, String> var1, @BinderParam(value=BindResourceIdsToIndexedFormParams.class) Iterable<String> var2);

    @Named(value="ec2:DescribeTags")
    @POST
    @Path(value="/")
    @FormParams(keys={"Action"}, values={"DescribeTags"})
    @XMLResponseParser(value=DescribeTagsResponseHandler.class)
    @ExceptionParser(value=ReturnEmptyFluentIterableOnNotFoundOr404.class)
    public ListenableFuture<FluentIterable<Tag>> list();

    @Named(value="ec2:DescribeTags")
    @POST
    @Path(value="/")
    @FormParams(keys={"Action"}, values={"DescribeTags"})
    @XMLResponseParser(value=DescribeTagsResponseHandler.class)
    @ExceptionParser(value=ReturnEmptyFluentIterableOnNotFoundOr404.class)
    public ListenableFuture<FluentIterable<Tag>> filter(@BinderParam(value=BindFiltersToIndexedFormParams.class) Multimap<String, String> var1);

    @Named(value="ec2:DeleteTags")
    @POST
    @Path(value="/")
    @FormParams(keys={"Action"}, values={"DeleteTags"})
    public ListenableFuture<Void> deleteFromResources(@BinderParam(value=BindTagKeysToIndexedFormParams.class) Iterable<String> var1, @BinderParam(value=BindResourceIdsToIndexedFormParams.class) Iterable<String> var2);

    @Named(value="ec2:DeleteTags")
    @POST
    @Path(value="/")
    @FormParams(keys={"Action"}, values={"DeleteTags"})
    public ListenableFuture<Void> conditionallyDeleteFromResources(@BinderParam(value=BindTagsToIndexedFormParams.class) Map<String, String> var1, @BinderParam(value=BindResourceIdsToIndexedFormParams.class) Iterable<String> var2);
}

