/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.ec2.domain;

import com.google.common.base.CaseFormat;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import java.util.Date;
import java.util.Set;
import org.jclouds.ec2.domain.Attachment;
import org.jclouds.javax.annotation.Nullable;

public class Volume
implements Comparable<Volume> {
    private final String region;
    private final String id;
    private final int size;
    @Nullable
    private final String snapshotId;
    private final String availabilityZone;
    private final Status status;
    private final Date createTime;
    private final Set<Attachment> attachments;

    public static Builder builder() {
        return new Builder();
    }

    public Volume(String region, String id, int size, String snapshotId, String availabilityZone, Status status, Date createTime, Iterable<Attachment> attachments) {
        this.region = Preconditions.checkNotNull(region, "region");
        this.id = id;
        this.size = size;
        this.snapshotId = snapshotId;
        this.availabilityZone = availabilityZone;
        this.status = status;
        this.createTime = createTime;
        this.attachments = ImmutableSet.copyOf(attachments);
    }

    @Deprecated
    public String getRegion() {
        return this.region;
    }

    public String getId() {
        return this.id;
    }

    public int getSize() {
        return this.size;
    }

    public String getSnapshotId() {
        return this.snapshotId;
    }

    public String getAvailabilityZone() {
        return this.availabilityZone;
    }

    public Status getStatus() {
        return this.status;
    }

    public Date getCreateTime() {
        return this.createTime;
    }

    public Set<Attachment> getAttachments() {
        return this.attachments;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.attachments == null ? 0 : ((Object)this.attachments).hashCode());
        result = 31 * result + (this.availabilityZone == null ? 0 : this.availabilityZone.hashCode());
        result = 31 * result + (this.createTime == null ? 0 : this.createTime.hashCode());
        result = 31 * result + (this.id == null ? 0 : this.id.hashCode());
        result = 31 * result + (this.region == null ? 0 : this.region.hashCode());
        result = 31 * result + this.size;
        result = 31 * result + (this.snapshotId == null ? 0 : this.snapshotId.hashCode());
        result = 31 * result + (this.status == null ? 0 : this.status.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Volume other = (Volume)obj;
        if (this.attachments == null ? other.attachments != null : !((Object)this.attachments).equals(other.attachments)) {
            return false;
        }
        if (this.availabilityZone == null ? other.availabilityZone != null : !this.availabilityZone.equals(other.availabilityZone)) {
            return false;
        }
        if (this.createTime == null ? other.createTime != null : !this.createTime.equals(other.createTime)) {
            return false;
        }
        if (this.id == null ? other.id != null : !this.id.equals(other.id)) {
            return false;
        }
        if (this.region == null ? other.region != null : !this.region.equals(other.region)) {
            return false;
        }
        if (this.size != other.size) {
            return false;
        }
        if (this.snapshotId == null ? other.snapshotId != null : !this.snapshotId.equals(other.snapshotId)) {
            return false;
        }
        return !(this.status == null ? other.status != null : !this.status.equals((Object)other.status));
    }

    @Override
    public int compareTo(Volume that) {
        return this.id.compareTo(that.id);
    }

    public String toString() {
        return "Volume [attachments=" + this.attachments + ", availabilityZone=" + this.availabilityZone + ", createTime=" + this.createTime + ", id=" + this.id + ", region=" + this.region + ", size=" + this.size + ", snapshotId=" + this.snapshotId + ", status=" + (Object)((Object)this.status) + "]";
    }

    public static class Builder {
        private String region;
        private String id;
        private int size;
        @Nullable
        private String snapshotId;
        private String availabilityZone;
        private Status status;
        private Date createTime;
        private Set<Attachment> attachments = ImmutableSet.of();

        public Builder region(String region) {
            this.region = region;
            return this;
        }

        public Builder id(String id) {
            this.id = id;
            return this;
        }

        public Builder size(int size) {
            this.size = size;
            return this;
        }

        public Builder snapshotId(String snapshotId) {
            this.snapshotId = snapshotId;
            return this;
        }

        public Builder availabilityZone(String availabilityZone) {
            this.availabilityZone = availabilityZone;
            return this;
        }

        public Builder status(Status status) {
            this.status = status;
            return this;
        }

        public Builder createTime(Date createTime) {
            this.createTime = createTime;
            return this;
        }

        public Builder attachments(Attachment ... attachments) {
            this.attachments = Sets.newHashSet(attachments);
            return this;
        }

        public Builder attachments(Set<Attachment> attachments) {
            this.attachments = ImmutableSet.copyOf(attachments);
            return this;
        }

        public Volume build() {
            return new Volume(this.region, this.id, this.size, this.snapshotId, this.availabilityZone, this.status, this.createTime, this.attachments);
        }
    }

    public static enum Status {
        CREATING,
        AVAILABLE,
        IN_USE,
        DELETING,
        ERROR,
        UNRECOGNIZED;


        public String value() {
            return CaseFormat.UPPER_UNDERSCORE.to(CaseFormat.LOWER_HYPHEN, this.name());
        }

        public String toString() {
            return this.value();
        }

        public static Status fromValue(String status) {
            try {
                return Status.valueOf(CaseFormat.LOWER_HYPHEN.to(CaseFormat.UPPER_UNDERSCORE, Preconditions.checkNotNull(status, "status")));
            }
            catch (IllegalArgumentException e) {
                return UNRECOGNIZED;
            }
        }
    }

    public static enum InstanceInitiatedShutdownBehavior {
        STOP,
        TERMINATE,
        UNRECOGNIZED;


        public String value() {
            return this.name().toLowerCase();
        }

        public String toString() {
            return this.value();
        }

        public static InstanceInitiatedShutdownBehavior fromValue(String status) {
            try {
                return InstanceInitiatedShutdownBehavior.valueOf(Preconditions.checkNotNull(status, "status").toUpperCase());
            }
            catch (IllegalArgumentException e) {
                return UNRECOGNIZED;
            }
        }
    }
}

