/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.deltacloud.xml;

import com.google.common.collect.Sets;
import java.util.Set;
import javax.inject.Inject;
import org.jclouds.deltacloud.domain.Realm;
import org.jclouds.deltacloud.xml.RealmHandler;
import org.jclouds.http.functions.ParseSax;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class RealmsHandler
extends ParseSax.HandlerWithResult<Set<? extends Realm>> {
    private StringBuilder currentText = new StringBuilder();
    private Set<Realm> realms = Sets.newLinkedHashSet();
    private final RealmHandler realmHandler;

    @Inject
    public RealmsHandler(RealmHandler realmHandler) {
        this.realmHandler = realmHandler;
    }

    @Override
    public Set<? extends Realm> getResult() {
        return this.realms;
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        this.realmHandler.startElement(uri, localName, qName, attributes);
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        this.realmHandler.endElement(uri, localName, qName);
        if (qName.equals("realm") && this.currentText.toString().trim().equals("")) {
            this.realms.add(this.realmHandler.getResult());
        }
        this.currentText = new StringBuilder();
    }

    @Override
    public void characters(char[] ch, int start, int length) {
        this.realmHandler.characters(ch, start, length);
        this.currentText.append(ch, start, length);
    }
}

