/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.deltacloud.xml;

import java.net.URI;
import java.util.Map;
import org.jclouds.deltacloud.domain.Realm;
import org.jclouds.http.functions.ParseSax;
import org.jclouds.util.SaxUtils;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class RealmHandler
extends ParseSax.HandlerWithResult<Realm> {
    private StringBuilder currentText = new StringBuilder();
    private URI href;
    private String id;
    private String name;
    private String limit;
    private Realm.State state;
    private Realm realm;

    @Override
    public Realm getResult() {
        return this.realm;
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attrs) throws SAXException {
        Map<String, String> attributes = SaxUtils.cleanseAttributes(attrs);
        if (attributes.containsKey("href")) {
            this.href = URI.create(attributes.get("href"));
            this.id = attributes.get("id");
        }
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        if (qName.equalsIgnoreCase("limit")) {
            this.limit = this.currentText.toString().trim();
            if ("".equals(this.limit)) {
                this.limit = null;
            }
        } else if (qName.equalsIgnoreCase("name")) {
            this.name = this.currentText.toString().trim();
        } else if (qName.equalsIgnoreCase("state")) {
            this.state = Realm.State.fromValue(this.currentText.toString().trim());
        } else if (qName.equalsIgnoreCase("realm")) {
            this.realm = new Realm(this.href, this.id, this.name, this.limit, this.state);
            this.href = null;
            this.id = null;
            this.name = null;
            this.limit = null;
            this.state = null;
        }
        this.currentText = new StringBuilder();
    }

    @Override
    public void characters(char[] ch, int start, int length) {
        this.currentText.append(ch, start, length);
    }
}

