/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.deltacloud.xml;

import com.google.common.collect.Sets;
import java.util.Set;
import javax.inject.Inject;
import org.jclouds.deltacloud.domain.Image;
import org.jclouds.deltacloud.xml.ImageHandler;
import org.jclouds.http.functions.ParseSax;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class ImagesHandler
extends ParseSax.HandlerWithResult<Set<? extends Image>> {
    private StringBuilder currentText = new StringBuilder();
    private Set<Image> images = Sets.newLinkedHashSet();
    private final ImageHandler imageHandler;

    @Inject
    public ImagesHandler(ImageHandler locationHandler) {
        this.imageHandler = locationHandler;
    }

    @Override
    public Set<? extends Image> getResult() {
        return this.images;
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        this.imageHandler.startElement(uri, localName, qName, attributes);
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        this.imageHandler.endElement(uri, localName, qName);
        if (qName.equals("image") && this.currentText.toString().trim().equals("")) {
            this.images.add(this.imageHandler.getResult());
        }
        this.currentText = new StringBuilder();
    }

    @Override
    public void characters(char[] ch, int start, int length) {
        this.imageHandler.characters(ch, start, length);
        this.currentText.append(ch, start, length);
    }
}

