/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.deltacloud.domain.internal;

import com.google.common.base.Preconditions;
import org.jclouds.deltacloud.domain.HardwareProperty;

public class BaseHardwareProperty
implements HardwareProperty {
    private final HardwareProperty.Kind kind;
    private final String name;
    private final String unit;
    private final Object value;

    public BaseHardwareProperty(HardwareProperty.Kind kind, String name, String unit, Object value) {
        this.kind = Preconditions.checkNotNull(kind, "kind");
        this.name = Preconditions.checkNotNull(name, "name");
        this.unit = Preconditions.checkNotNull(unit, "unit");
        this.value = Preconditions.checkNotNull(value, "value");
    }

    @Override
    public HardwareProperty.Kind getKind() {
        return this.kind;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getUnit() {
        return this.unit;
    }

    @Override
    public Object getValue() {
        return this.value;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.kind == null ? 0 : this.kind.hashCode());
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + (this.unit == null ? 0 : this.unit.hashCode());
        result = 31 * result + (this.value == null ? 0 : this.value.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        BaseHardwareProperty other = (BaseHardwareProperty)obj;
        if (this.kind != other.kind) {
            return false;
        }
        if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
            return false;
        }
        if (this.unit == null ? other.unit != null : !this.unit.equals(other.unit)) {
            return false;
        }
        return !(this.value == null ? other.value != null : !this.value.equals(other.value));
    }

    public String toString() {
        return "[kind=" + (Object)((Object)this.kind) + ", name=" + this.name + ", unit=" + this.unit + ", value=" + this.value + "]";
    }
}

