/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.deltacloud.domain;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.net.URI;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import org.jclouds.http.HttpRequest;
import org.jclouds.javax.annotation.Nullable;

public class Instance {
    private final URI href;
    private final String id;
    private final String ownerId;
    @Nullable
    private final String name;
    private final URI image;
    private final URI hardwareProfile;
    private final URI realm;
    private final State state;
    private final Map<Action, HttpRequest> actions;
    @Nullable
    private final Authentication authentication;
    private final Set<String> publicAddresses;
    private final Set<String> privateAddresses;

    public Instance(URI href, String id, String ownerId, @Nullable String name, URI image, URI hardwareProfile, URI realm, State state, Map<Action, HttpRequest> actions, @Nullable Authentication authentication, Set<String> publicAddresses, Set<String> privateAddresses) {
        this.href = Preconditions.checkNotNull(href, "href");
        this.id = Preconditions.checkNotNull(id, "id");
        this.ownerId = Preconditions.checkNotNull(ownerId, "ownerId");
        this.name = name;
        this.image = Preconditions.checkNotNull(image, "image");
        this.hardwareProfile = Preconditions.checkNotNull(hardwareProfile, "hardwareProfile");
        this.realm = Preconditions.checkNotNull(realm, "realm");
        this.state = Preconditions.checkNotNull(state, "state");
        this.actions = ImmutableMap.copyOf(Preconditions.checkNotNull(actions, "actions"));
        this.authentication = authentication;
        this.publicAddresses = ImmutableSet.copyOf((Collection)Preconditions.checkNotNull(publicAddresses, "publicAddresses"));
        this.privateAddresses = ImmutableSet.copyOf((Collection)Preconditions.checkNotNull(privateAddresses, "privateAddresses"));
    }

    public URI getHref() {
        return this.href;
    }

    public String getId() {
        return this.id;
    }

    public String getOwnerId() {
        return this.ownerId;
    }

    @Nullable
    public String getName() {
        return this.name;
    }

    public URI getImage() {
        return this.image;
    }

    public URI getHardwareProfile() {
        return this.hardwareProfile;
    }

    public URI getRealm() {
        return this.realm;
    }

    public State getState() {
        return this.state;
    }

    public Map<Action, HttpRequest> getActions() {
        return this.actions;
    }

    @Nullable
    public Authentication getAuthentication() {
        return this.authentication;
    }

    public Set<String> getPublicAddresses() {
        return this.publicAddresses;
    }

    public Set<String> getPrivateAddresses() {
        return this.privateAddresses;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.href == null ? 0 : this.href.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Instance other = (Instance)obj;
        return !(this.href == null ? other.href != null : !this.href.equals(other.href));
    }

    public String toString() {
        return String.format("[id=%s, href=%s, image=%s, name=%s, state=%s, realm=%s, ownerId=%s, hardwareProfile=%s, actions=%s, authentication=%s, privateAddresses=%s, publicAddresses=%s]", new Object[]{this.id, this.href, this.image, this.name, this.state, this.realm, this.ownerId, this.hardwareProfile, this.actions, this.authentication, this.privateAddresses, this.publicAddresses});
    }

    public static enum Action {
        CREATE,
        RUN,
        REBOOT,
        START,
        STOP,
        DESTROY,
        UNRECOGNIZED;


        public String value() {
            return this.name().toLowerCase();
        }

        public String toString() {
            return this.value();
        }

        public static Action fromValue(String action) {
            try {
                return Action.valueOf(Preconditions.checkNotNull(action, "action").toUpperCase());
            }
            catch (IllegalArgumentException e) {
                return UNRECOGNIZED;
            }
        }
    }

    public static enum State {
        START,
        PENDING,
        RUNNING,
        SHUTTING_DOWN,
        STOPPED,
        FINISH,
        UNRECOGNIZED;


        public static State fromValue(String state) {
            try {
                return State.valueOf(Preconditions.checkNotNull(state, "state").toUpperCase());
            }
            catch (IllegalArgumentException e) {
                return UNRECOGNIZED;
            }
        }
    }

    public static interface Authentication {
    }
}

