/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.deltacloud.domain;

import com.google.common.base.Preconditions;
import java.net.URI;

public class HardwareParameter {
    private final URI href;
    private final String method;
    private final String name;
    private final String operation;

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.href == null ? 0 : this.href.hashCode());
        result = 31 * result + (this.method == null ? 0 : this.method.hashCode());
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + (this.operation == null ? 0 : this.operation.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        HardwareParameter other = (HardwareParameter)obj;
        if (this.href == null ? other.href != null : !this.href.equals(other.href)) {
            return false;
        }
        if (this.method == null ? other.method != null : !this.method.equals(other.method)) {
            return false;
        }
        if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
            return false;
        }
        return !(this.operation == null ? other.operation != null : !this.operation.equals(other.operation));
    }

    public HardwareParameter(URI href, String method, String name, String operation) {
        this.href = Preconditions.checkNotNull(href, "href");
        this.method = Preconditions.checkNotNull(method, "method");
        this.name = Preconditions.checkNotNull(name, "name");
        this.operation = Preconditions.checkNotNull(operation, "operation");
    }

    public URI getHref() {
        return this.href;
    }

    public String getMethod() {
        return this.method;
    }

    public String getName() {
        return this.name;
    }

    public String getOperation() {
        return this.operation;
    }

    public String toString() {
        return "[href=" + this.href + ", method=" + this.method + ", name=" + this.name + ", operation=" + this.operation + "]";
    }
}

