/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.compute.predicates;

import com.google.common.base.Predicate;
import javax.annotation.Resource;
import javax.inject.Singleton;
import org.jclouds.compute.domain.ExecResponse;
import org.jclouds.logging.Logger;
import org.jclouds.ssh.SshClient;

@Singleton
public class ScriptStatusReturnsZero
implements Predicate<CommandUsingClient> {
    @Resource
    protected Logger logger = Logger.NULL;

    @Override
    public boolean apply(CommandUsingClient commandUsingClient) {
        this.logger.trace("looking for [%s] state on %s@%s", commandUsingClient.command, commandUsingClient.client.getUsername(), commandUsingClient.client.getHostAddress());
        ExecResponse response = this.refresh(commandUsingClient);
        while (response.getExitStatus() == -1) {
            response = this.refresh(commandUsingClient);
        }
        this.logger.trace("%s@%s: looking for exit code 0: currently: %s", commandUsingClient.client.getUsername(), commandUsingClient.client.getHostAddress(), response.getExitStatus());
        return 0 == response.getExitStatus();
    }

    private ExecResponse refresh(CommandUsingClient commandUsingClient) {
        return commandUsingClient.client.exec(commandUsingClient.command);
    }

    public static class CommandUsingClient {
        private final String command;
        private final SshClient client;

        public CommandUsingClient(String command, SshClient client) {
            this.command = command;
            this.client = client;
        }
    }
}

