/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.cloudstack.options;

import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableSet;
import org.jclouds.cloudstack.domain.PermissionOperation;
import org.jclouds.http.options.BaseHttpRequestOptions;

public class UpdateISOPermissionsOptions
extends BaseHttpRequestOptions {
    public static final UpdateISOPermissionsOptions NONE = new UpdateISOPermissionsOptions();

    public UpdateISOPermissionsOptions accounts(Iterable<String> accounts) {
        this.queryParameters.replaceValues("accounts", ImmutableSet.of(Joiner.on(',').join(accounts)));
        return this;
    }

    public UpdateISOPermissionsOptions isExtractable(boolean isExtractable) {
        this.queryParameters.replaceValues("isextractable", ImmutableSet.of(isExtractable + ""));
        return this;
    }

    public UpdateISOPermissionsOptions isFeatured(boolean isFeatured) {
        this.queryParameters.replaceValues("isfeatured", ImmutableSet.of(isFeatured + ""));
        return this;
    }

    public UpdateISOPermissionsOptions isPublic(boolean isPublic) {
        this.queryParameters.replaceValues("ispublic", ImmutableSet.of(isPublic + ""));
        return this;
    }

    public UpdateISOPermissionsOptions operation(PermissionOperation operation) {
        this.queryParameters.replaceValues("op", ImmutableSet.of((Object)((Object)operation) + ""));
        return this;
    }

    public static class Builder {
        public static UpdateISOPermissionsOptions accounts(Iterable<String> accounts) {
            return new UpdateISOPermissionsOptions().accounts(accounts);
        }

        public static UpdateISOPermissionsOptions isExtractable(boolean isExtractable) {
            return new UpdateISOPermissionsOptions().isExtractable(isExtractable);
        }

        public static UpdateISOPermissionsOptions isFeatured(boolean isFeatured) {
            return new UpdateISOPermissionsOptions().isFeatured(isFeatured);
        }

        public static UpdateISOPermissionsOptions isPublic(boolean isPublic) {
            return new UpdateISOPermissionsOptions().isPublic(isPublic);
        }

        public static UpdateISOPermissionsOptions operation(PermissionOperation operation) {
            return new UpdateISOPermissionsOptions().operation(operation);
        }
    }
}

