/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.cloudstack.options;

import com.google.common.collect.ImmutableSet;
import org.jclouds.cloudstack.domain.TemplateFilter;
import org.jclouds.cloudstack.options.AccountInDomainOptions;

public class ListTemplatesOptions
extends AccountInDomainOptions {
    public static final ListTemplatesOptions NONE = new ListTemplatesOptions();

    public ListTemplatesOptions() {
        this.filter(TemplateFilter.EXECUTABLE);
    }

    public ListTemplatesOptions filter(TemplateFilter filter) {
        this.queryParameters.replaceValues("templatefilter", ImmutableSet.of(filter.toString()));
        return this;
    }

    public ListTemplatesOptions id(String id) {
        this.queryParameters.replaceValues("id", ImmutableSet.of(id + ""));
        return this;
    }

    public ListTemplatesOptions name(String name) {
        this.queryParameters.replaceValues("name", ImmutableSet.of(name));
        return this;
    }

    public ListTemplatesOptions zoneId(String zoneId) {
        this.queryParameters.replaceValues("zoneid", ImmutableSet.of(zoneId + ""));
        return this;
    }

    public ListTemplatesOptions hypervisor(String hypervisor) {
        this.queryParameters.replaceValues("hypervisor", ImmutableSet.of(hypervisor));
        return this;
    }

    @Override
    public ListTemplatesOptions accountInDomain(String account, String domain) {
        return (ListTemplatesOptions)ListTemplatesOptions.class.cast(super.accountInDomain(account, domain));
    }

    @Override
    public ListTemplatesOptions domainId(String domainId) {
        return (ListTemplatesOptions)ListTemplatesOptions.class.cast(super.domainId(domainId));
    }

    public static class Builder {
        public static ListTemplatesOptions filter(TemplateFilter filter) {
            ListTemplatesOptions options = new ListTemplatesOptions();
            return options.filter(filter);
        }

        public static ListTemplatesOptions domainId(String id) {
            ListTemplatesOptions options = new ListTemplatesOptions();
            return options.domainId(id);
        }

        public static ListTemplatesOptions accountInDomain(String account, String domain) {
            ListTemplatesOptions options = new ListTemplatesOptions();
            return options.accountInDomain(account, domain);
        }

        public static ListTemplatesOptions id(String id) {
            ListTemplatesOptions options = new ListTemplatesOptions();
            return options.id(id);
        }

        public static ListTemplatesOptions name(String name) {
            ListTemplatesOptions options = new ListTemplatesOptions();
            return options.name(name);
        }

        public static ListTemplatesOptions zoneId(String id) {
            ListTemplatesOptions options = new ListTemplatesOptions();
            return options.zoneId(id);
        }

        public static ListTemplatesOptions hypervisor(String hypervisor) {
            ListTemplatesOptions options = new ListTemplatesOptions();
            return options.hypervisor(hypervisor);
        }
    }
}

