/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.cloudstack.options;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import java.util.Date;
import org.jclouds.cloudstack.options.AccountInDomainOptions;
import org.jclouds.date.DateService;
import org.jclouds.date.internal.SimpleDateFormatDateService;

public class ListAsyncJobsOptions
extends AccountInDomainOptions {
    private static final DateService dateService = new SimpleDateFormatDateService();
    public static final ListAsyncJobsOptions NONE = new ListAsyncJobsOptions();

    public ListAsyncJobsOptions startDate(Date startDate) {
        this.queryParameters.replaceValues("startdate", ImmutableSet.of(dateService.iso8601SecondsDateFormat(Preconditions.checkNotNull(startDate, "startDate"))));
        return this;
    }

    @Override
    public ListAsyncJobsOptions accountInDomain(String account, String domain) {
        return (ListAsyncJobsOptions)ListAsyncJobsOptions.class.cast(super.accountInDomain(account, domain));
    }

    @Override
    public ListAsyncJobsOptions domainId(String domainId) {
        return (ListAsyncJobsOptions)ListAsyncJobsOptions.class.cast(super.domainId(domainId));
    }

    public static class Builder {
        public static ListAsyncJobsOptions startDate(Date startDate) {
            ListAsyncJobsOptions options = new ListAsyncJobsOptions();
            return options.startDate(startDate);
        }

        public static ListAsyncJobsOptions domainId(String id) {
            ListAsyncJobsOptions options = new ListAsyncJobsOptions();
            return options.domainId(id);
        }

        public static ListAsyncJobsOptions accountInDomain(String account, String domain) {
            ListAsyncJobsOptions options = new ListAsyncJobsOptions();
            return options.accountInDomain(account, domain);
        }
    }
}

